/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.guards;

import electric.glue.IGLUELoggingConstants;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.security.IWSSConstants;
import electric.soap.security.guards.IWSSGuard;
import electric.soap.security.signature.WSSSignature;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.log.Log;
import electric.xml.Element;
import electric.xml.IXPath;
import electric.xml.XPathException;
import java.util.Enumeration;
import java.util.Vector;

public class SignatureGuard
implements IWSSGuard,
ISOAPConstants,
IWSSConstants,
IGLUELoggingConstants {
    private WSSSignature signatureSpec = null;

    public SignatureGuard(WSSSignature signatureSpec) {
        this.signatureSpec = signatureSpec;
    }

    public boolean authorize(SOAPMessage message, Vector signatures, Vector encryptions, Vector principalList, Vector authorizationCredentials) {
        try {
            int authCount = 0;
            int i = 0;
            while (i < signatures.size()) {
                WSSSignature signature = (WSSSignature)signatures.elementAt(i);
                if (!this.authorizeSignature(message, signature)) {
                    return false;
                }
                ++authCount;
                ++i;
            }
            if (authCount != signatures.size() || authCount < 1) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean authorizeSignature(SOAPMessage message, WSSSignature signature) throws Exception {
        Enumeration references = this.signatureSpec.getReferences();
        while (references.hasMoreElements()) {
            ElementReference requiredReference = (ElementReference)references.nextElement();
            Element requiredElement = this.getReferencedElement(message, requiredReference);
            if (requiredElement == null) {
                if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                    Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)("required element not in message: " + requiredReference.getPath()));
                }
                return false;
            }
            if (this.isSigned(requiredElement, signature, message)) continue;
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)("required element not signed: " + requiredReference.getPath()));
            }
            return false;
        }
        return true;
    }

    private boolean isSigned(Element requiredElement, WSSSignature signature, SOAPMessage message) throws Exception {
        Enumeration signedReferences = signature.getReferences();
        while (signedReferences.hasMoreElements()) {
            ElementReference signedReference = (ElementReference)signedReferences.nextElement();
            Element signedElement = this.getReferencedElement(message, signedReference);
            if (requiredElement != signedElement) continue;
            return true;
        }
        return false;
    }

    private Element getReferencedElement(SOAPMessage message, ElementReference signedReference) throws Exception {
        IXPath signedXPath = null;
        if (signedReference == null) {
            return null;
        }
        String signedPath = signedReference.getPath();
        signedXPath = this.handleHashPath(signedPath);
        if (signedXPath == null) {
            signedXPath = this.handlePath(signedPath);
        }
        if (signedXPath == null) {
            return null;
        }
        return signedXPath.getElement(message.getDocument());
    }

    private IXPath handleHashPath(String signedPath) throws XPathException {
        if (!signedPath.startsWith("#")) {
            return null;
        }
        String signedId = signedPath.substring(1);
        String idPath = "//*[@wsu:Id=\"" + signedId + '\"' + "]";
        IXPath signedXPath = SecurityXPathFactory.createXPath(idPath);
        signedXPath.setNamespace("wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
        return signedXPath;
    }

    private IXPath handlePath(String signedPath) throws XPathException {
        IXPath signedXPath = SecurityXPathFactory.createXPath(signedPath);
        signedXPath.setNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        return signedXPath;
    }
}

