/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.initializer;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.security.IRealm;
import electric.security.Realms;
import electric.service.descriptor.IInitializer;
import electric.service.descriptor.ServiceDescriptor;
import electric.soap.security.IWSSConfigConstants;
import electric.soap.security.IWSSConstants;
import electric.soap.security.IWSSContextConstants;
import electric.soap.security.SOAPSecurityException;
import electric.soap.security.WSSContext;
import electric.soap.security.authenticators.IWSSAuthenticator;
import electric.soap.security.authenticators.UsernameTokenAuthenticator;
import electric.soap.security.authenticators.X509Authenticator;
import electric.soap.security.encryption.WSSEncryption;
import electric.soap.security.guards.EncryptionGuard;
import electric.soap.security.guards.IWSSGuard;
import electric.soap.security.guards.RoleGuard;
import electric.soap.security.guards.SignatureGuard;
import electric.soap.security.signature.WSSSignature;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.util.KeyStoreUtil;
import electric.util.Context;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.Creator;
import electric.xml.Element;
import electric.xml.Elements;
import java.security.KeyStore;
import java.util.Enumeration;

public final class Security
implements IInitializer,
IGLUELoggingConstants,
IGLUEContextConstants,
IWSSConstants,
IWSSContextConstants,
IWSSConfigConstants {
    public void create(ServiceDescriptor descriptor, ClassLoader loader) throws Throwable {
        this.createAuthenticators(descriptor);
        this.createSignatureGuards(descriptor);
        this.createEncryptionGuards(descriptor);
        this.createUserGuards(descriptor);
    }

    private void createAuthenticators(ServiceDescriptor descriptor) throws Throwable {
        Element[] authenticates = descriptor.getExtensibilityElements("wssAuthenticate");
        int i = 0;
        while (i < authenticates.length) {
            if (!this.createUsernameAuthenticator(descriptor, authenticates[i]) && !this.createX509Authenticator(descriptor, authenticates[i])) {
                this.createUserDefinedAuthenticator(descriptor, authenticates[i]);
            }
            ++i;
        }
    }

    private boolean createUserDefinedAuthenticator(ServiceDescriptor descriptor, Element authenticateElement) throws Throwable {
        try {
            String name = authenticateElement.getString("name");
            IWSSAuthenticator authenticator = (IWSSAuthenticator)Creator.newInstance(authenticateElement, null);
            Context serviceContext = descriptor.getContext();
            WSSContext wss = this.getWSSContext(serviceContext);
            wss.in.addAuthenticator(authenticator, name);
            return true;
        }
        catch (Throwable throwable) {
            block2: {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) break block2;
                Log.log(ILoggingConstants.STARTUP_EVENT, "could not create user-defined authenticator " + authenticateElement, throwable);
            }
            return false;
        }
    }

    private boolean createX509Authenticator(ServiceDescriptor descriptor, Element authenticate) throws Throwable {
        String trustStorePass;
        String name = authenticate.getString("name");
        String trustStoreName = authenticate.getTrimTextString("trustStore");
        if (trustStoreName == null) {
            return false;
        }
        String trustStoreURL = authenticate.getString("trustStore");
        if (trustStoreURL == null) {
            trustStoreURL = Context.getSystemProperty("javax.net.ssl.trustStore");
        }
        if ((trustStorePass = authenticate.getString("trustStorePassword")) == null) {
            trustStorePass = Context.getSystemProperty("javax.net.ssl.trustStorePassword");
        }
        if (name == null) {
            name = trustStoreURL;
        }
        KeyStore trustStore = KeyStoreUtil.loadKeyStoreResource(trustStoreURL, trustStorePass, null);
        Context serviceContext = descriptor.getContext();
        WSSContext wss = this.getWSSContext(serviceContext);
        this.addAuthenticatorIfNeeded(wss, trustStore, trustStoreURL, name);
        return true;
    }

    private boolean createUsernameAuthenticator(ServiceDescriptor descriptor, Element authenticate) throws Throwable {
        String name = authenticate.getString("name");
        String realmName = authenticate.getTrimTextString("realm");
        if (realmName == null) {
            return false;
        }
        Context serviceContext = descriptor.getContext();
        WSSContext wss = this.getWSSContext(serviceContext);
        IRealm realm = Realms.getRealm(realmName);
        if (realm == null) {
            throw new SOAPSecurityException("security service configuration, realm not found:" + realmName);
        }
        this.addRoles(wss, realm, authenticate.getElements("role"));
        if (name == null) {
            name = realmName;
        }
        wss.in.addAuthenticator(new UsernameTokenAuthenticator(realm), name);
        return true;
    }

    private void addRoles(WSSContext wss, IRealm realm, Elements rolesElements) {
        if (rolesElements != null) {
            String[] roles = new String[rolesElements.size()];
            int i = 0;
            while (rolesElements.hasMoreElements()) {
                roles[i++] = rolesElements.next().getString().trim();
            }
            wss.in.addGuard(new RoleGuard(realm, roles));
        }
    }

    private void createSignatureGuards(ServiceDescriptor descriptor) throws Throwable {
        Element[] signatures = descriptor.getExtensibilityElements("wssSignature");
        int i = 0;
        while (i < signatures.length) {
            this.createSignatureGuard(descriptor, signatures[i]);
            ++i;
        }
    }

    public void createSignatureGuard(ServiceDescriptor descriptor, Element signatureElement) throws Throwable {
        String name = signatureElement.getString("name");
        String trustStoreURL = signatureElement.getString("trustStore");
        Context serviceContext = descriptor.getContext();
        WSSContext wss = this.getWSSContext(serviceContext);
        if (trustStoreURL != null) {
            String trustStorePass = signatureElement.getString("trustStorePassword");
            if (trustStorePass == null) {
                trustStorePass = null;
            }
            KeyStore trustStore = KeyStoreUtil.loadKeyStoreResource(trustStoreURL, trustStorePass, null);
            if (name == null) {
                name = trustStoreURL;
            }
            this.addAuthenticatorIfNeeded(wss, trustStore, trustStoreURL, name);
        } else {
            String authenticatorName = signatureElement.getString("authenticator");
            if (authenticatorName == null) {
                throw new SOAPSecurityException("signature guard must have truststore or authenticator");
            }
            IWSSAuthenticator authenticator = wss.in.getAuthenticatorByName(authenticatorName);
            if (authenticator == null) {
                throw new SOAPSecurityException("guard references unknown authenticator: " + authenticatorName);
            }
        }
        WSSSignature signatureSpec = new WSSSignature();
        this.addReferences(signatureSpec, signatureElement);
        wss.in.addGuard(new SignatureGuard(signatureSpec));
    }

    private void addAuthenticatorIfNeeded(WSSContext wss, KeyStore trustStore, String trustStoreURL, String name) {
        Enumeration authenticators = wss.in.authenticators();
        while (authenticators.hasMoreElements()) {
            X509Authenticator x509Authenticator;
            IWSSAuthenticator authenticator = (IWSSAuthenticator)authenticators.nextElement();
            if (!(authenticator instanceof X509Authenticator) || !(x509Authenticator = (X509Authenticator)authenticator).getTrustStoreURL().equals(x509Authenticator.getTrustStoreURL())) continue;
            return;
        }
        wss.in.addAuthenticator(new X509Authenticator(trustStore, trustStoreURL), name);
    }

    private void addReferences(WSSSignature signatureSpec, Element signatureElement) {
        Elements references = signatureElement.getElements("reference");
        while (references.hasMoreElements()) {
            String referencePath = references.next().getString();
            ElementReference reference = new ElementReference(referencePath);
            signatureSpec.addReference(reference);
        }
    }

    private synchronized WSSContext getWSSContext(Context serviceContext) {
        WSSContext wss = (WSSContext)serviceContext.getProperty("wssContext");
        if (wss == null) {
            wss = new WSSContext();
            serviceContext.addProperty("wssContext", wss);
        }
        return wss;
    }

    private void createEncryptionGuards(ServiceDescriptor descriptor) throws Throwable {
        Element[] encryptions = descriptor.getExtensibilityElements("wssEncryption");
        if (encryptions.length > 0) {
            Context serviceContext = descriptor.getContext();
            WSSContext wss = this.getWSSContext(serviceContext);
            int i = 0;
            while (i < encryptions.length) {
                this.createEncryptionGuard(wss, encryptions[i]);
                ++i;
            }
        }
    }

    private void createEncryptionGuard(WSSContext wss, Element encryptionSpecElement) throws SOAPSecurityException {
        WSSEncryption encryption = new WSSEncryption();
        String referencePath = encryptionSpecElement.getString("reference");
        ElementReference reference = new ElementReference(referencePath);
        encryption.setReference(reference);
        Element secretKey = encryptionSpecElement.getElement("secretKey");
        if (secretKey == null) {
            throw new SOAPSecurityException("service descriptor, encryption, secret key required");
        }
        String realmName = secretKey.getString("realm");
        if (secretKey == null) {
            throw new SOAPSecurityException("service descriptor, encryption secret key, realm required");
        }
        IRealm realm = Realms.getRealm(realmName);
        if (realm == null) {
            throw new SOAPSecurityException("service descriptor, realm not found: " + realmName);
        }
        encryption.setRealm(realm);
        wss.in.addGuard(new EncryptionGuard(encryption));
    }

    private void createUserGuards(ServiceDescriptor descriptor) throws Throwable {
        Element[] guards = descriptor.getExtensibilityElements("wssGuard");
        int i = 0;
        while (i < guards.length) {
            this.createUserGuard(descriptor, guards[i]);
            ++i;
        }
    }

    private void createUserGuard(ServiceDescriptor descriptor, Element userGuardElement) throws Throwable {
        block2: {
            try {
                IWSSGuard guard = (IWSSGuard)Creator.newInstance(userGuardElement, null);
                Context serviceContext = descriptor.getContext();
                WSSContext wss = this.getWSSContext(serviceContext);
                wss.in.addGuard(guard);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) break block2;
                Log.log(ILoggingConstants.STARTUP_EVENT, "could not create user-defined authenticator " + userGuardElement, throwable);
            }
        }
    }
}

