/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.signature;

import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.security.IWSSConstants;
import electric.soap.security.SOAPSecurityException;
import electric.soap.security.WSSContext;
import electric.soap.security.signature.WSSKeyInfoProcessor;
import electric.soap.security.signature.WSSReferenceProcessor;
import electric.soap.security.signature.WSSSignature;
import electric.soap.security.signature.xml.IKeyInfoProcessor;
import electric.soap.security.signature.xml.IReferenceProcessor;
import electric.soap.security.signature.xml.IXMLSignatureConstants;
import electric.soap.security.signature.xml.XMLSignatureException;
import electric.soap.security.signature.xml.XMLSignatureProcessor;
import electric.soap.security.tokens.SecurityTokenFactory;
import electric.soap.security.tokens.SecurityTokenProcessor;
import electric.soap.security.tokens.X509v3SecurityToken;
import electric.soap.security.util.SecurityXPathFactory;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IXMLConstants;
import electric.xml.IXPath;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Vector;

public class WSSSignatureProcessor
implements IWSSConstants,
IXMLSignatureConstants,
IXMLConstants,
ISOAPConstants {
    private IReferenceProcessor referenceProcessor;
    private IKeyInfoProcessor keyInfoProcessor;
    private SecurityTokenProcessor tokenProcessor;

    public WSSSignatureProcessor(SecurityTokenProcessor tokenProcessor) {
        this.tokenProcessor = tokenProcessor;
        this.referenceProcessor = new WSSReferenceProcessor();
        this.keyInfoProcessor = new WSSKeyInfoProcessor();
    }

    public void addTokens(SOAPMessage message, WSSContext wss, Element securityElement, Hashtable tokenToId) {
        Vector signatures = wss.out.getSignatures();
        int i = 0;
        while (i < signatures.size()) {
            WSSSignature signature = (WSSSignature)signatures.elementAt(i);
            X509Certificate cert = signature.getCertificate();
            if (cert != null) {
                X509v3SecurityToken certToken = new X509v3SecurityToken(cert);
                this.tokenProcessor.addToken(message, wss, securityElement, certToken);
                signature.setReferencedToken(certToken);
            }
            ++i;
        }
    }

    public void addSignatures(SOAPMessage message, WSSContext wss, Element securityElement) throws SOAPSecurityException {
        Vector signatures = wss.out.getSignatures();
        WSSReferenceProcessor referenceProcessor = new WSSReferenceProcessor();
        int i = 0;
        while (i < signatures.size()) {
            WSSSignature signature = (WSSSignature)signatures.elementAt(i);
            Element signatureElement = null;
            try {
                signatureElement = XMLSignatureProcessor.addSignature(message.getDocument(), signature, securityElement, referenceProcessor, this.keyInfoProcessor);
            }
            catch (XMLSignatureException exception) {
                // empty catch block
            }
            if (signatureElement == null) {
                throw new SOAPSecurityException("WSSSignatureProcessor:configuration problem, could not add signature");
            }
            ++i;
        }
    }

    public boolean validateSignatures(SOAPMessage message, WSSContext wss, Vector signatures, Vector securityTokens) {
        boolean allValid = true;
        try {
            SecurityTokenFactory tokenFactory = wss.in.getTokenFactory();
            boolean r = this.validateSOAPSignature(tokenFactory, message, signatures, securityTokens);
            if (!r) {
                allValid = false;
            }
        }
        catch (Throwable exception) {
            allValid = false;
            exception.printStackTrace();
        }
        return allValid;
    }

    public boolean validateSOAPSignature(SecurityTokenFactory factory, SOAPMessage msg, Vector signatures, Vector securityTokens) throws Exception {
        Document doc = msg.getDocument();
        IXPath xpathSec = SecurityXPathFactory.createXPath("//wsse:Security[1]");
        xpathSec.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        Element securityElement = xpathSec.getElement(doc.getRoot());
        if (securityElement == null) {
            return true;
        }
        IXPath xpathSig = SecurityXPathFactory.createXPath("//wsse:Security/ds:Signature");
        xpathSig.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        xpathSig.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        Elements signatureElements = xpathSig.getElements(doc.getRoot());
        boolean allValid = true;
        while (signatureElements.hasMoreElements()) {
            WSSSignature signature = new WSSSignature();
            Element signatureElement = (Element)signatureElements.nextElement();
            if (signatureElement == null) continue;
            Element envelopeElement = (Element)doc.getDocumentElement();
            boolean signatureValid = XMLSignatureProcessor.verifySignature(envelopeElement, signatureElement, securityTokens, signature, this.referenceProcessor, this.keyInfoProcessor);
            allValid |= signatureValid;
            if (!signatureValid) continue;
            signatures.addElement(signature);
        }
        return allValid;
    }
}

