/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.signature.xml.crypto;

import electric.soap.security.signature.xml.XMLSignature;
import electric.soap.security.signature.xml.XMLSignatureException;
import electric.soap.security.signature.xml.crypto.ISignatureAlgorithm;
import electric.soap.security.tokens.SecurityToken;
import electric.soap.security.tokens.UsernameToken;
import electric.util.string.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACwithSHA1
implements ISignatureAlgorithm {
    public boolean verify(XMLSignature signature, SecurityToken securityToken, byte[] bytesToSign, byte[] messageSignature) throws XMLSignatureException {
        byte[] digestBytes = this.sign(signature, securityToken, bytesToSign);
        if (digestBytes.length != messageSignature.length) {
            return false;
        }
        int i = 0;
        while (i < digestBytes.length) {
            if (digestBytes[i] != messageSignature[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] sign(XMLSignature signature, SecurityToken securityToken, byte[] bytesToSign) throws XMLSignatureException {
        UsernameToken usernameToken = (UsernameToken)securityToken;
        String password = usernameToken.getDigestedPassword();
        if (password == null) {
            password = usernameToken.getPassword();
        }
        if (password == null) {
            throw new IllegalArgumentException("pasword cannot be null");
        }
        byte[] passwordBytes = Base64.fromBase64(password);
        SecretKeySpec key = new SecretKeySpec(passwordBytes, "HMACSHA1");
        byte[] digestBytes = null;
        try {
            Mac mac = Mac.getInstance("HMACSHA1");
            mac.init(key);
            digestBytes = mac.doFinal(bytesToSign);
        }
        catch (Exception exception) {
            throw new XMLSignatureException("HMACwithSHA1 error", exception);
        }
        return digestBytes;
    }
}

