/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.tokens;

import electric.soap.security.IWSSConstants;
import electric.soap.security.tokens.BinarySecurityToken;
import electric.util.string.Base64;
import electric.xml.Element;
import electric.xml.Text;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class X509v3SecurityToken
extends BinarySecurityToken
implements IWSSConstants {
    protected String valueType;
    protected String encodingType;
    protected X509Certificate certificate;

    public X509v3SecurityToken() {
    }

    public X509v3SecurityToken(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public Element getElement() {
        Element tokElement = new Element("wsse", "BinarySecurityToken", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        tokElement.setAttribute("ValueType", "wsse:X509v3");
        tokElement.setAttribute("EncodingType", "wsse:Base64Binary");
        String id = this.getId();
        if (id != null) {
            tokElement.setNamespace("wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
            tokElement.setAttribute("wsu", "Id", id);
        }
        try {
            byte[] data = this.certificate.getEncoded();
            String data64 = Base64.toBase64(data);
            tokElement.setText(data64);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return tokElement;
    }

    public void setElement(Element token) {
        this.valueType = token.getAttribute("ValueType");
        String encodingType = token.getAttribute("EncodingType");
        if (encodingType == null || !encodingType.equals("wsse:Base64Binary")) {
            return;
        }
        token.normalize();
        Text text = (Text)token.getFirstChild();
        String data = text.getData();
        byte[] certData = Base64.fromBase64(data);
        this.setId(token.getAttributeValue("Id"));
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bistr = new ByteArrayInputStream(certData);
            this.certificate = (X509Certificate)cf.generateCertificate(bistr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate cert) {
        this.certificate = cert;
    }
}

