/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.util;

import electric.soap.ISOAPConstants;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.io.schema.SchemaProperties;
import java.util.Hashtable;

public class SOAPEnvelopes
implements ISOAPConstants {
    private static final Hashtable parseContext = new Hashtable();

    public static Document newOptimizedEnvelope() {
        Document document = new Document(parseContext);
        document.setWriteXMLDecl(false);
        return document;
    }

    public static Document newEncodedEnvelope(String version) {
        if (version == null) {
            version = SchemaProperties.getDefaultSchema();
        }
        return SOAPEnvelopes.newEncodedEnvelope(version, "http://schemas.xmlsoap.org/soap/envelope/");
    }

    public static Document newEncodedEnvelope(String version, String soapVersion) {
        if (version == null) {
            version = SchemaProperties.getDefaultSchema();
        }
        return SOAPEnvelopes.getEncodedEnvelope(version, soapVersion);
    }

    public static Document newLiteralEnvelope(String version) {
        if (version == null) {
            version = SchemaProperties.getDefaultSchema();
        }
        return SOAPEnvelopes.getLiteralEnvelope(version);
    }

    private static Document getEncodedEnvelope(String version) {
        return SOAPEnvelopes.getEncodedEnvelope(version, "http://schemas.xmlsoap.org/soap/envelope/");
    }

    private static Document getEncodedEnvelope(String version, String soapVersion) {
        String encodingNamespace;
        String envelopeNamespace;
        Document document = new Document();
        Element envelope = document.newRoot();
        if (soapVersion == null) {
            return null;
        }
        if (soapVersion.equals("http://www.w3.org/2003/05/soap-envelope")) {
            envelopeNamespace = "http://www.w3.org/2003/05/soap-envelope";
            encodingNamespace = "http://www.w3.org/2003/05/soap-encoding";
        } else {
            envelopeNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
            encodingNamespace = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        envelope.setNamespace("xsi", version + "-instance");
        envelope.setNamespace("xsd", version);
        envelope.setNamespace("soap", envelopeNamespace);
        envelope.setNamespace("soapenc", encodingNamespace);
        envelope.setName("soap", "Envelope");
        Element body = envelope.addElement("soap", "Body");
        if (soapVersion.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            body.setAttribute("soap", "encodingStyle", encodingNamespace);
        }
        return document;
    }

    private static Document getLiteralEnvelope(String version) {
        Document document = new Document();
        Element envelope = document.newRoot();
        envelope.setNamespace("xsi", version + "-instance");
        envelope.setNamespace("xsd", version);
        envelope.setNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        envelope.setName("soap", "Envelope");
        envelope.addElement("soap", "Body");
        return document;
    }

    private static void initParseContext() {
        parseContext.put("xsi", SchemaProperties.getDefaultSchema() + "-instance");
        parseContext.put("xsd", SchemaProperties.getDefaultSchema());
        parseContext.put("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        parseContext.put("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
        parseContext.put("tme", SchemaProperties.getTmeNamespace());
    }

    public static Hashtable getParseContext() {
        return parseContext;
    }

    static {
        SOAPEnvelopes.initParseContext();
    }
}

