/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.util;

import electric.glue.IGLUELoggingConstants;
import electric.soap.ISOAPInterceptor;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.util.Enumeration;
import java.util.Vector;

public final class SOAPInterceptors
implements IGLUELoggingConstants {
    public static void callInterceptors(Context context, Context messageContext, String name, SOAPMessage message) {
        Vector interceptors = SOAPInterceptors.getInterceptors(context, name);
        if (interceptors == null) {
            return;
        }
        message.deoptimize();
        Enumeration enumeration = interceptors.elements();
        while (enumeration.hasMoreElements()) {
            ((ISOAPInterceptor)enumeration.nextElement()).intercept(message, messageContext);
        }
    }

    private static Vector getInterceptors(Context context, String name) {
        Vector interceptors = null;
        Enumeration enumeration = Context.application().getProperties(name);
        if (enumeration.hasMoreElements()) {
            interceptors = new Vector();
            SOAPInterceptors.addInterceptors(enumeration, interceptors);
        }
        if (context != null && (enumeration = context.getProperties(name)).hasMoreElements()) {
            SOAPInterceptors.addInterceptors(enumeration, interceptors == null ? (interceptors = new Vector()) : interceptors);
        }
        return interceptors;
    }

    private static void addInterceptors(Enumeration enumeration, Vector interceptors) {
        while (enumeration.hasMoreElements()) {
            Object configObject = enumeration.nextElement();
            if (configObject instanceof ISOAPInterceptor) {
                interceptors.addElement(configObject);
                continue;
            }
            if (!(configObject instanceof String)) continue;
            interceptors.addElement(SOAPInterceptors.newInterceptor((String)configObject));
        }
    }

    private static ISOAPInterceptor newInterceptor(String className) {
        try {
            Class interceptorClass = ClassLoaders.loadClass(className);
            return (ISOAPInterceptor)interceptorClass.newInstance();
        }
        catch (ClassCastException exception) {
            throw new RuntimeException(className + " did not implement ISOAPInterceptor");
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException("unable to find interceptor class " + className);
        }
        catch (Exception exception) {
            String error = "unable to create interceptor object " + className;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, error, exception);
            }
            throw new RuntimeException(error);
        }
    }
}

