/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.util.comparators.AscendingStringComparator;
import electric.util.dictionary.IdentityHashtable;
import electric.util.sorting.BubbleSort;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.WSDL;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.schema.SchemaException;
import electric.xml.substitute.TagData;
import java.util.Vector;

public class WSDLTagData
implements IWSDLConstants {
    static final IdentityHashtable wsdlToTagData = new IdentityHashtable();

    public static synchronized TagData getTagData(WSDL wsdl) {
        TagData tagData = (TagData)wsdlToTagData.get(wsdl);
        if (tagData != null) {
            return tagData;
        }
        tagData = new TagData();
        try {
            Vector items = new Vector();
            WSDLTagData.addSubstitute(items, "Result");
            WSDLTagData.addSubstitute(items, "xsi");
            WSDLTagData.addSubstitute(items, "type");
            WSDLTagData.addSubstitute(items, "soapenc");
            WSDLTagData.addSubstitute(items, "arrayType");
            WSDLTagData.addSubstitutes(items, wsdl.getDocument().getRoot());
            Object[] names = new String[items.size()];
            items.copyInto(names);
            BubbleSort.sort(names, new AscendingStringComparator());
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < names.length) {
                Object name = names[i];
                String code = new Integer(i).toString();
                tagData.mapCodeToName(code, (String)name);
                buffer.append((String)name);
                ++i;
            }
            tagData.setHashCode(Math.abs(buffer.toString().hashCode()));
        }
        catch (SchemaException exception) {
            // empty catch block
        }
        wsdlToTagData.put(wsdl, tagData);
        return tagData;
    }

    private static void addSubstitutes(Vector items, Element element) {
        String name;
        if (element.hasName("complexType") || element.hasName("element") || element.hasName("part") || element.hasName("attribute")) {
            name = element.getAttributeValue("name");
            if (name != null) {
                WSDLTagData.addSubstitute(items, name);
            }
        } else if (element.hasName("operation") && (name = element.getAttributeValue("name")) != null) {
            WSDLTagData.addSubstitute(items, name);
            WSDLTagData.addSubstitute(items, name + "Response");
        }
        Elements elements = element.getElements();
        while (elements.hasMoreElements()) {
            WSDLTagData.addSubstitutes(items, elements.next());
        }
    }

    private static void addSubstitute(Vector items, String name) {
        if (!items.contains(name)) {
            items.addElement(name);
        }
    }
}

