/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl.util;

import electric.util.array.ArrayUtil;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaProperties;

public class WSDLUtil {
    private static final String BASE64BINARY = "base64Binary";
    private static final String HEXBINARY = "hexBinary";
    private static final String SOAPENCODING_NAMESPACE = "http://schemas.xmlsoap.org/soap/encoding/";

    public static boolean isBinaryType(Type type) {
        boolean isBinary;
        if (type == null) {
            return false;
        }
        String typeNamespace = type.getNamespace();
        if (typeNamespace == null) {
            return false;
        }
        String[] namespaceCandidates = SchemaProperties.getXSDS();
        if (namespaceCandidates == null) {
            namespaceCandidates = new String[]{};
        }
        if (isBinary = WSDLUtil.isBinaryType(namespaceCandidates = (String[])ArrayUtil.addElement(namespaceCandidates, SOAPENCODING_NAMESPACE), BASE64BINARY, type.getQName())) {
            return true;
        }
        isBinary = WSDLUtil.isBinaryType(namespaceCandidates, HEXBINARY, typeNamespace);
        return isBinary;
    }

    private static boolean isBinaryType(String[] namespaceCandidates, String typeName, String typeQName) {
        int i = 0;
        while (i < namespaceCandidates.length) {
            String qname = namespaceCandidates[i] + ":" + typeName;
            if (qname.equals(typeQName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

