/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.transaction.Transaction;
import electric.uddi.Assertion;
import electric.uddi.Authorization;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class DeleteAssertions
implements IPublicationCommand {
    private Assertion[] assertions;
    static /* synthetic */ Class class$electric$uddi$Assertion;

    public DeleteAssertions() {
    }

    public DeleteAssertions(Assertion[] assertions) {
        this.assertions = assertions;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            int i = 0;
            while (i < this.assertions.length) {
                DeleteAssertions.deleteAssertion(server, this.assertions[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return null;
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    public static void deleteAssertion(IUDDIServer server, Assertion assertion, User user) throws UDDIException {
        try {
            assertion = server.readAssertion(assertion.getAssertionKey());
        }
        catch (UDDIException exception) {
            throw new UDDIException(30000);
        }
        assertion.unassertUser(server, user);
        if (assertion.hasNoUsers()) {
            server.eraseAssertion(assertion.getAssertionKey());
        } else {
            server.writeAssertion(assertion);
        }
    }

    public static void eraseAssertion(IUDDIServer server, Assertion assertion) throws UDDIException {
        User user;
        String fromUserName = assertion.getFromUserName();
        String toUserName = assertion.getToUserName();
        if (fromUserName != null) {
            user = server.readUser(fromUserName);
            server.checkLimits(user);
        }
        if (toUserName != null && !ArrayUtil.equals(fromUserName, toUserName)) {
            user = server.readUser(toUserName);
            server.checkLimits(user);
        }
        server.eraseAssertion(assertion.getAssertionKey());
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("delete_publisherAssertions");
        UDDIUtil.writeList(query, this.assertions);
    }

    public void read(IReader reader) throws IOException {
        IReader[] readers = reader.getReaders("publisherAssertion");
        this.assertions = (Assertion[])UDDIUtil.readList(readers, class$electric$uddi$Assertion == null ? (class$electric$uddi$Assertion = DeleteAssertions.class$("electric.uddi.Assertion")) : class$electric$uddi$Assertion);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

