/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.transaction.Transaction;
import electric.uddi.Assertion;
import electric.uddi.Authorization;
import electric.uddi.DeleteAssertions;
import electric.uddi.DeleteServices;
import electric.uddi.GetAssertions;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class DeleteBusinesses
implements IPublicationCommand {
    private String[] businessKeys;

    public DeleteBusinesses() {
    }

    public DeleteBusinesses(String[] businessKeys) {
        this.businessKeys = businessKeys;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            int i = 0;
            while (i < this.businessKeys.length) {
                DeleteBusinesses.deleteBusiness(server, this.businessKeys[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return null;
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    public static void deleteBusiness(IUDDIServer server, String businessKey, User user) throws UDDIException {
        if (!server.ownsBusiness(businessKey, user)) {
            throw new UDDIException(10140);
        }
        String[] serviceKeys = server.getServiceKeysForBusiness(businessKey);
        int i = 0;
        while (i < serviceKeys.length) {
            DeleteServices.deleteService(server, serviceKeys[i], user);
            ++i;
        }
        Assertion[] assertions = GetAssertions.getAssertions(server, businessKey, null, null);
        int i2 = 0;
        while (i2 < assertions.length) {
            DeleteAssertions.eraseAssertion(server, assertions[i2]);
            ++i2;
        }
        server.eraseBusiness(businessKey);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("delete_business");
        UDDIUtil.writeStringList(query, "businessKey", this.businessKeys);
    }

    public void read(IReader reader) throws IOException {
        this.businessKeys = UDDIUtil.getTexts(reader, "businessKey");
    }
}

