/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.transaction.Transaction;
import electric.uddi.Authorization;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.TModel;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class DeleteTModels
implements IPublicationCommand {
    private String[] tModelKeys;

    public DeleteTModels() {
    }

    public DeleteTModels(String[] tModelKeys) {
        this.tModelKeys = tModelKeys;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            int i = 0;
            while (i < this.tModelKeys.length) {
                DeleteTModels.deleteTModel(server, server.readTModel(this.tModelKeys[i]), user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return null;
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    public static void deleteTModel(IUDDIServer server, TModel tModel, User user) throws UDDIException {
        if (!server.ownsTModel(tModel, user)) {
            throw new UDDIException(10140);
        }
        tModel.setHidden(true);
        server.writeTModel(tModel);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("delete_tModel");
        UDDIUtil.writeStringList(query, "tModelKey", this.tModelKeys);
    }

    public void read(IReader reader) throws IOException {
        this.tModelKeys = UDDIUtil.getTexts(reader, "tModelKey");
    }
}

