/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.ISecurityPolicyCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.util.string.Base64;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class GetAuthorization
implements ISecurityPolicyCommand {
    public String userId;
    public String cred;

    public GetAuthorization() {
    }

    public GetAuthorization(String userId, String cred) {
        this.userId = userId;
        this.cred = cred;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        if (this.userId == null || this.userId == "" || this.cred == null) {
            throw new UDDIException(10120);
        }
        User user = null;
        try {
            user = server.readUser(this.userId);
        }
        catch (UDDIException exception) {
            throw new UDDIException(10150);
        }
        if (!user.getPassword().equals(this.cred)) {
            throw new UDDIException(10150);
        }
        String token = Base64.toBase64((user.getName() + "|" + user.getPassword()).getBytes());
        return new Authorization(token);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("get_authToken");
        query.writeAttribute("userID", this.userId);
        query.writeAttribute("cred", this.cred);
    }

    public void read(IReader reader) throws IOException {
        this.userId = reader.readAttributeValue("userID");
        this.cred = reader.readAttributeValue("cred");
    }
}

