/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Business;
import electric.uddi.Description;
import electric.uddi.IUDDIConstants;
import electric.uddi.Identifier;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.util.named.INamed;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class RelatedBusinessInfo
implements ISerializable,
INamed,
IUDDIConstants {
    private String businessKey = "";
    private String name;
    private Description[] descriptions = new Description[0];
    private Identifier[] relationships = new Identifier[0];
    static /* synthetic */ Class class$electric$uddi$Identifier;

    public RelatedBusinessInfo() {
    }

    public RelatedBusinessInfo(Business business, Identifier identifier) {
        this.businessKey = business.getBusinessKey();
        this.name = business.getName();
        this.descriptions = business.getDescriptions();
        this.addRelationship(identifier);
    }

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("relatedBusinessInfo"));
            this.write(writer);
            return writer.getElement().getFirstElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getName() {
        return this.name;
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public Identifier[] getRelationships() {
        return this.relationships;
    }

    public void addRelationship(Identifier identifier) {
        this.relationships = (Identifier[])ArrayUtil.addElement(this.relationships, identifier);
    }

    public void write(IWriter writer) throws IOException {
        IWriter relatedBusinessInfo = writer.writeElement("relatedBusinessInfo");
        relatedBusinessInfo.writeString("businessKey", this.businessKey);
        relatedBusinessInfo.writeString("name", this.name);
        Description.writeList(relatedBusinessInfo, this.descriptions);
        if (this.relationships.length > 0) {
            UDDIUtil.writeList(relatedBusinessInfo, "sharedRelationships", this.relationships);
        }
    }

    public void read(IReader reader) throws IOException {
        this.businessKey = reader.readString("businessKey");
        this.name = reader.readString("name");
        this.descriptions = Description.readList(reader);
        this.relationships = (Identifier[])UDDIUtil.readList(reader.getReader("sharedRelationships"), class$electric$uddi$Identifier == null ? (class$electric$uddi$Identifier = RelatedBusinessInfo.class$("electric.uddi.Identifier")) : class$electric$uddi$Identifier);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

