/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.transaction.Transaction;
import electric.uddi.Authorization;
import electric.uddi.Binding;
import electric.uddi.Bindings;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.util.UUID;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class SaveBindings
implements IPublicationCommand {
    private Binding[] bindings;
    static /* synthetic */ Class class$electric$uddi$Binding;

    public SaveBindings() {
    }

    public SaveBindings(Binding[] bindings) {
        this.bindings = bindings;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            Binding[] results = new Binding[this.bindings.length];
            int i = 0;
            while (i < this.bindings.length) {
                results[i] = this.saveBinding(server, this.bindings[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return new Bindings(results);
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    private Binding saveBinding(IUDDIServer server, Binding newBinding, User user) throws UDDIException {
        if (newBinding.getBindingKey() == null) {
            newBinding.setBindingKey("");
        }
        if (!server.ownsService(newBinding.getServiceKey(), user)) {
            throw new UDDIException(10140);
        }
        SaveBindings.saveBindingPhase1(server, newBinding, user);
        SaveBindings.saveBindingPhase2(server, newBinding, user);
        return newBinding;
    }

    public static void saveBindingPhase1(IUDDIServer server, Binding newBinding, User user) throws UDDIException {
        if (newBinding.getBindingKey().length() > 0 && !server.ownsBinding(newBinding.getBindingKey(), user)) {
            throw new UDDIException(10140);
        }
    }

    public static void saveBindingPhase2(IUDDIServer server, Binding newBinding, User user) throws UDDIException {
        newBinding.setUserName(user.getName());
        if (newBinding.getBindingKey().length() == 0) {
            newBinding.setBindingKey(new UUID().getKey());
        }
        server.writeBinding(newBinding);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("save_binding");
        UDDIUtil.writeList(query, this.bindings);
    }

    public void read(IReader reader) throws IOException {
        IReader[] readers = reader.getReaders("bindingTemplate");
        this.bindings = (Binding[])UDDIUtil.readList(readers, class$electric$uddi$Binding == null ? (class$electric$uddi$Binding = SaveBindings.class$("electric.uddi.Binding")) : class$electric$uddi$Binding);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

