/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.transaction.Transaction;
import electric.uddi.Authorization;
import electric.uddi.Binding;
import electric.uddi.DeleteBindings;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.SaveBindings;
import electric.uddi.Service;
import electric.uddi.Services;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.util.UUID;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class SaveServices
implements IPublicationCommand {
    private Service[] services;
    static /* synthetic */ Class class$electric$uddi$Service;

    public SaveServices() {
    }

    public SaveServices(Service[] services) {
        this.services = services;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            Service[] results = new Service[this.services.length];
            int i = 0;
            while (i < this.services.length) {
                results[i] = this.saveService(server, this.services[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return new Services(results);
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    private Service saveService(IUDDIServer server, Service newService, User user) throws UDDIException {
        if (newService.getServiceKey() == null) {
            newService.setServiceKey("");
        }
        SaveServices.saveServicePhase1(server, newService, user);
        SaveServices.saveServicePhase2(server, newService, user);
        if (!server.ownsBusiness(newService.getBusinessKey(), user)) {
            throw new UDDIException(10140);
        }
        return newService;
    }

    public static void saveServicePhase1(IUDDIServer server, Service newService, User user) throws UDDIException {
        if (newService.getServiceKey().length() > 0 && !server.ownsService(newService.getServiceKey(), user)) {
            throw new UDDIException(10140);
        }
        Binding[] newBindings = newService.getBindings();
        int i = 0;
        while (i < newBindings.length) {
            SaveBindings.saveBindingPhase1(server, newBindings[i], user);
            ++i;
        }
    }

    public static void saveServicePhase2(IUDDIServer server, Service newService, User user) throws UDDIException {
        int i;
        newService.setUserName(user.getName());
        if (newService.getServiceKey().length() == 0) {
            newService.setServiceKey(new UUID().getKey());
        } else {
            String[] oldBindingKeys = server.getBindingKeysForService(newService.getServiceKey());
            i = 0;
            while (i < oldBindingKeys.length) {
                if (newService.getBinding(oldBindingKeys[i]) == null) {
                    DeleteBindings.deleteBinding(server, oldBindingKeys[i], user);
                }
                ++i;
            }
        }
        Binding[] newBindings = newService.getBindings();
        i = 0;
        while (i < newBindings.length) {
            SaveBindings.saveBindingPhase2(server, newBindings[i], user);
            ++i;
        }
        server.writeService(newService);
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("save_service");
        int i = 0;
        while (i < this.services.length) {
            this.services[i].write(query, true, false);
            ++i;
        }
    }

    public void read(IReader reader) throws IOException {
        IReader[] readers = reader.getReaders("businessService");
        this.services = (Service[])UDDIUtil.readList(readers, class$electric$uddi$Service == null ? (class$electric$uddi$Service = SaveServices.class$("electric.uddi.Service")) : class$electric$uddi$Service);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

