/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.http.OutboundHTTPRequest;
import electric.transaction.Transaction;
import electric.uddi.Authorization;
import electric.uddi.IPublicationCommand;
import electric.uddi.IUDDIServer;
import electric.uddi.TModel;
import electric.uddi.TModels;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.util.UDDIUtil;
import electric.util.Context;
import electric.util.UUID;
import electric.xml.Document;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralReader;
import java.io.IOException;

public final class SaveTModels
implements IPublicationCommand {
    private TModel[] tModels;
    private String[] urls;
    static /* synthetic */ Class class$electric$uddi$TModel;

    public SaveTModels() {
    }

    public SaveTModels(TModel[] tModels) {
        this.tModels = tModels;
    }

    public SaveTModels(String[] urls) {
        this.urls = urls;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        if (this.urls != null) {
            return this.saveTModels(server, authorization, this.getTModels(this.urls));
        }
        return this.saveTModels(server, authorization, this.tModels);
    }

    private TModel[] getTModels(String[] urls) throws UDDIException {
        TModel[] tModels = new TModel[urls.length];
        int i = 0;
        while (i < urls.length) {
            try {
                tModels[i] = new TModel();
                OutboundHTTPRequest request = new OutboundHTTPRequest();
                byte[] bytes = request.get(urls[i], new Context());
                Document document = new Document(bytes);
                tModels[i].read(new LiteralReader(document.getRoot()));
            }
            catch (Exception exception) {
                throw new UDDIException(exception.toString());
            }
            ++i;
        }
        return tModels;
    }

    private TModels saveTModels(IUDDIServer server, Authorization authorization, TModel[] tModels) throws UDDIException {
        try {
            Transaction.begin();
            User user = server.getPublisher(authorization);
            TModel[] results = new TModel[tModels.length];
            int i = 0;
            while (i < tModels.length) {
                results[i] = this.saveTModel(server, tModels[i], user);
                ++i;
            }
            server.checkLimits(user);
            Transaction.commit();
            return new TModels(results);
        }
        catch (UDDIException exception) {
            Transaction.rollback();
            throw exception;
        }
        catch (Throwable throwable) {
            Transaction.rollback();
            throw new UDDIException(throwable);
        }
    }

    private TModel saveTModel(IUDDIServer server, TModel tModel, User user) throws UDDIException {
        if (tModel.getTModelKey() == null) {
            tModel.setTModelKey("");
        }
        tModel.setUserName(user.getName());
        if (tModel.getTModelKey().length() == 0) {
            tModel.setTModelKey("uuid:" + new UUID().getKey());
        } else {
            if (server.readTModel(tModel.getTModelKey()) == null) {
                throw new UDDIException(10210);
            }
            if (!server.ownsTModel(tModel, user)) {
                throw new UDDIException(10140);
            }
        }
        tModel.setOperator(server.getOperator());
        tModel.setHidden(false);
        server.writeTModel(tModel);
        return tModel;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("save_tModel");
        if (this.tModels != null) {
            UDDIUtil.writeList(query, this.tModels);
        } else {
            UDDIUtil.writeStringList(query, "uploadRegister", this.urls);
        }
    }

    public void read(IReader reader) throws IOException {
        if (reader.readElement("tModel") != null) {
            IReader[] readers = reader.getReaders("tModel");
            this.tModels = (TModel[])UDDIUtil.readList(readers, class$electric$uddi$TModel == null ? (class$electric$uddi$TModel = SaveTModels.class$("electric.uddi.TModel")) : class$electric$uddi$TModel);
        } else {
            this.urls = UDDIUtil.getTexts(reader, "uploadRegister");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

