/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Binding;
import electric.uddi.Category;
import electric.uddi.Description;
import electric.uddi.ICategorized;
import electric.uddi.IUDDIConstants;
import electric.uddi.Name;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.util.named.INamed;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class Service
implements ISerializable,
INamed,
ICategorized,
IUDDIConstants {
    private String businessKey = "";
    private String serviceKey = "";
    private Name[] names = new Name[0];
    private Description[] descriptions = new Description[0];
    private Binding[] bindings = new Binding[0];
    private Category[] categories = new Category[0];
    private String userName;
    static /* synthetic */ Class class$electric$uddi$Binding;
    static /* synthetic */ Class class$electric$uddi$Category;

    public Service() {
    }

    public Service(String name) {
        this.addName(new Name(name));
    }

    public Service(Service service) {
        this.businessKey = service.businessKey;
        this.serviceKey = service.serviceKey;
        this.names = service.names;
        this.descriptions = service.descriptions;
        this.bindings = service.bindings;
        this.categories = service.categories;
        this.userName = service.userName;
    }

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("Service"));
            this.write(writer, true, true);
            return writer.getElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Service)) {
            return false;
        }
        Service service = (Service)object;
        return this.serviceKey.equals(service.getServiceKey());
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
        int i = 0;
        while (i < this.bindings.length) {
            this.bindings[i].setServiceKey(serviceKey);
            ++i;
        }
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public Name[] getNames() {
        return this.names;
    }

    public void setNames(Name[] names) {
        this.names = names;
    }

    public void addName(Name name) {
        this.names = (Name[])ArrayUtil.addElement(this.names, name);
    }

    public void removeName(Name name) {
        this.names = (Name[])ArrayUtil.removeElement(this.names, name);
    }

    public String getName() {
        return this.names.length == 0 ? null : this.names[0].getText();
    }

    public void setName(String text) {
        this.names = new Name[]{new Name(text)};
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void addBinding(Binding binding) {
        this.removeBinding(binding.getBindingKey());
        binding.setServiceKey(this.serviceKey);
        this.bindings = (Binding[])ArrayUtil.addElement(this.bindings, binding);
    }

    public void removeBinding(Binding binding) {
        this.removeBinding(binding.getBindingKey());
    }

    public void removeBinding(String bindingKey) {
        int i = 0;
        while (i < this.bindings.length) {
            if (bindingKey.equals(this.bindings[i].getBindingKey())) {
                this.bindings = (Binding[])ArrayUtil.removeElementAt(this.bindings, i);
                return;
            }
            ++i;
        }
    }

    public Binding[] getBindings() {
        return this.bindings;
    }

    public String[] getBindingKeys() {
        String[] bindingKeys = new String[this.bindings.length];
        int i = 0;
        while (i < this.bindings.length) {
            bindingKeys[i] = this.bindings[i].getBindingKey();
            ++i;
        }
        return bindingKeys;
    }

    public Binding getBinding(String bindingKey) {
        int i = 0;
        while (i < this.bindings.length) {
            if (bindingKey.equals(this.bindings[i].getBindingKey())) {
                return this.bindings[i];
            }
            ++i;
        }
        return null;
    }

    public void setBindings(Binding[] bindings) {
        this.bindings = bindings;
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Description[] descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.addElement(this.descriptions, description);
    }

    public void removeDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.removeElement(this.descriptions, description);
    }

    public void addCategory(Category category) {
        this.categories = (Category[])ArrayUtil.addElement(this.categories, category);
    }

    public void removeCategory(Category category) {
        this.categories = (Category[])ArrayUtil.removeElement(this.categories, category);
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public Category getCategoryWithName(String name) {
        int i = 0;
        while (i < this.categories.length) {
            if (name.equals(this.categories[i].getName())) {
                return this.categories[i];
            }
            ++i;
        }
        return null;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void write(IWriter writer) throws IOException {
        this.write(writer, false, true);
    }

    public void write(IWriter writer, boolean includeBindings, boolean includeUserName) throws IOException {
        IWriter entity = writer.writeElement("businessService");
        entity.writeAttribute("serviceKey", this.serviceKey);
        entity.writeAttribute("businessKey", this.businessKey);
        if (includeUserName && this.userName != null) {
            entity.writeAttribute("userName", this.userName);
        }
        Name.writeList(entity, this.names);
        Description.writeList(entity, this.descriptions);
        if (includeBindings && this.bindings.length > 0) {
            IWriter bindingTemplates = entity.writeElement("bindingTemplates");
            int i = 0;
            while (i < this.bindings.length) {
                this.bindings[i].write(bindingTemplates);
                ++i;
            }
        }
        if (this.categories.length > 0) {
            Category.writeList(entity, this.categories);
        }
    }

    public void read(IReader reader) throws IOException {
        this.serviceKey = reader.readAttributeValue("serviceKey");
        this.businessKey = reader.readAttributeValue("businessKey");
        this.userName = reader.readAttributeValue("userName");
        this.names = Name.readList(reader);
        this.descriptions = Description.readList(reader);
        Binding[] bindings = (Binding[])UDDIUtil.readList(reader.getReader("bindingTemplates"), class$electric$uddi$Binding == null ? (class$electric$uddi$Binding = Service.class$("electric.uddi.Binding")) : class$electric$uddi$Binding);
        int i = 0;
        while (i < bindings.length) {
            this.addBinding(bindings[i]);
            ++i;
        }
        this.categories = (Category[])UDDIUtil.readList(reader.getReader("categoryBag"), class$electric$uddi$Category == null ? (class$electric$uddi$Category = Service.class$("electric.uddi.Category")) : class$electric$uddi$Category);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

