/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Description;
import electric.uddi.IUDDIConstants;
import electric.uddi.Overview;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class TModelInstance
implements ISerializable,
IUDDIConstants {
    private String tModelKey;
    private Description[] descriptions = new Description[0];
    private Description[] instanceDescriptions = new Description[0];
    private Overview instanceOverview;
    private String instanceParms;

    public TModelInstance() {
    }

    public TModelInstance(String tModelKey) {
        this.tModelKey = tModelKey;
    }

    public String toString() {
        return "TModelInstance( tModelKey: " + this.tModelKey + " )";
    }

    public void setTModelKey(String tModelKey) {
        this.tModelKey = tModelKey;
    }

    public String getTModelKey() {
        return this.tModelKey;
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Description[] descriptions) {
        this.descriptions = descriptions;
    }

    public void addDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.addElement(this.descriptions, description);
    }

    public void removeDescription(Description description) {
        this.descriptions = (Description[])ArrayUtil.removeElement(this.descriptions, description);
    }

    public void addInstanceDescription(Description description) {
        this.instanceDescriptions = (Description[])ArrayUtil.addElement(this.instanceDescriptions, description);
    }

    public Description[] getInstanceDescriptions() {
        return this.instanceDescriptions;
    }

    public void setInstanceDescriptions(Description[] instanceDescriptions) {
        this.instanceDescriptions = instanceDescriptions;
    }

    public void setInstanceOverview(Overview overview) {
        this.instanceOverview = overview;
    }

    public Overview getInstanceOverview() {
        return this.instanceOverview;
    }

    public void setInstanceParms(String parameters) {
        this.instanceParms = parameters;
    }

    public String getInstanceParms() {
        return this.instanceParms;
    }

    public void write(IWriter writer) throws IOException {
        IWriter entity = writer.writeElement("tModelInstanceInfo");
        entity.writeAttribute("tModelKey", this.tModelKey);
        Description.writeList(entity, this.descriptions);
        if (this.instanceDescriptions.length > 0 || this.instanceOverview != null || this.instanceParms != null) {
            IWriter instance = entity.writeElement("instanceDetails");
            Description.writeList(instance, this.instanceDescriptions);
            if (this.instanceOverview != null) {
                this.instanceOverview.write(instance);
            }
            if (this.instanceParms != null) {
                instance.writeString("instanceParms", this.instanceParms);
            }
        }
    }

    public void read(IReader reader) throws IOException {
        this.tModelKey = reader.readAttributeValue("tModelKey");
        this.descriptions = Description.readList(reader);
        IReader instanceDetailsXML = reader.getReader("instanceDetails");
        if (instanceDetailsXML != null) {
            this.instanceDescriptions = Description.readList(instanceDetailsXML);
            IReader overviewXML = instanceDetailsXML.getReader("overviewDoc");
            if (overviewXML != null) {
                this.instanceOverview = new Overview();
                this.instanceOverview.read(overviewXML);
            }
            this.instanceParms = instanceDetailsXML.readString("instanceParms");
        }
    }
}

