/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.client;

import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.server.Servers;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.http.reference.SOAPToHTTP;
import electric.soap.local.reference.SOAPLocalTransport;
import electric.uddi.AddAssertions;
import electric.uddi.Assertion;
import electric.uddi.AssertionStatusReport;
import electric.uddi.Assertions;
import electric.uddi.Authorization;
import electric.uddi.Binding;
import electric.uddi.Bindings;
import electric.uddi.Business;
import electric.uddi.BusinessInfos;
import electric.uddi.Businesses;
import electric.uddi.Category;
import electric.uddi.DeleteAssertions;
import electric.uddi.DeleteBindings;
import electric.uddi.DeleteBusinesses;
import electric.uddi.DeleteServices;
import electric.uddi.DeleteSubscriptions;
import electric.uddi.DeleteTModels;
import electric.uddi.DiscardAuthorization;
import electric.uddi.DiscoveryURL;
import electric.uddi.FindBindings;
import electric.uddi.FindBusinesses;
import electric.uddi.FindRelatedBusinesses;
import electric.uddi.FindServices;
import electric.uddi.FindTModels;
import electric.uddi.GetAssertionStatusReport;
import electric.uddi.GetAssertions;
import electric.uddi.GetAuthorization;
import electric.uddi.GetBindings;
import electric.uddi.GetBusinesses;
import electric.uddi.GetBusinessesExtended;
import electric.uddi.GetOperationalInfo;
import electric.uddi.GetRegistered;
import electric.uddi.GetServices;
import electric.uddi.GetSubscriptionResults;
import electric.uddi.GetSubscriptions;
import electric.uddi.GetTModels;
import electric.uddi.ICommand;
import electric.uddi.IInquiryCommand;
import electric.uddi.IUDDIConstants;
import electric.uddi.IUDDIServer;
import electric.uddi.IUDDIServerHolder;
import electric.uddi.Identifier;
import electric.uddi.Messages;
import electric.uddi.Name;
import electric.uddi.OperationalInfos;
import electric.uddi.Qualifier;
import electric.uddi.Registered;
import electric.uddi.RelatedBusinessInfos;
import electric.uddi.SaveBindings;
import electric.uddi.SaveBusinesses;
import electric.uddi.SaveServices;
import electric.uddi.SaveSubscriptions;
import electric.uddi.SaveTModels;
import electric.uddi.Service;
import electric.uddi.ServiceInfos;
import electric.uddi.Services;
import electric.uddi.SetAssertions;
import electric.uddi.Subscription;
import electric.uddi.SubscriptionResults;
import electric.uddi.Subscriptions;
import electric.uddi.TModel;
import electric.uddi.TModelInfos;
import electric.uddi.TModels;
import electric.uddi.UDDIException;
import electric.util.Context;
import electric.util.XURL;
import electric.util.log.Log;
import electric.util.product.Product;
import electric.util.time.Duration;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.io.ISerializable;
import electric.xml.io.literal.LiteralReader;
import electric.xml.io.literal.LiteralWriter;
import java.rmi.RemoteException;

public final class UDDIClient
implements IUDDIConstants,
ISOAPConstants,
IGLUELoggingConstants {
    private String inquiryURL;
    private ISOAPHandler inquiryHandler;
    private String publicationURL;
    private ISOAPHandler publicationHandler;
    private String user;
    private String password;
    private Authorization authorization;
    private Context context;
    private IUDDIServer server;

    public UDDIClient(String inquiryURL) throws UDDIException {
        this(inquiryURL, new Context());
    }

    public UDDIClient(String inquiryURL, Context context) throws UDDIException {
        this(inquiryURL, null, null, null, context);
    }

    public UDDIClient(String inquiryURL, String publicationURL, String user, String password) throws UDDIException {
        this(inquiryURL, publicationURL, user, password, new Context());
    }

    public UDDIClient(String inquiryURL, String publicationURL, String user, String password, Context context) throws UDDIException {
        this.context = context;
        if (inquiryURL != null) {
            this.setInquiryURL(inquiryURL);
        }
        if (publicationURL != null) {
            this.setPublicationURL(publicationURL);
        }
        this.user = user;
        this.password = password;
    }

    public String toString() {
        return "UDDIClient( inquiryURL=" + this.inquiryURL + ", publicationURL=" + this.publicationURL + ", user=" + this.user + ", password=" + this.password + " )";
    }

    public IUDDIServer getServer() {
        return this.server;
    }

    public boolean isLocal() {
        return this.server != null;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private void setInquiryURL(String inquiryURL) throws UDDIException {
        this.inquiryURL = inquiryURL;
        try {
            String localPath;
            XURL endpoint = new XURL(inquiryURL);
            String string = localPath = endpoint.getProtocol() != null ? Servers.getLocalPath(endpoint) : endpoint.getFile();
            if (localPath != null) {
                Object object = Registry.get(localPath);
                this.server = ((IUDDIServerHolder)object).getUDDIServer();
                this.inquiryHandler = new SOAPLocalTransport(new XURL(localPath), (IService)object);
            } else {
                this.inquiryHandler = new SOAPToHTTP(endpoint);
            }
        }
        catch (Exception exception) {
            throw new UDDIException(exception.getMessage(), "2.0");
        }
    }

    public String getInquiryURL() {
        return this.inquiryURL;
    }

    private void setPublicationURL(String publicationURL) throws UDDIException {
        this.publicationURL = publicationURL;
        try {
            String localPath;
            XURL endpoint = new XURL(publicationURL);
            String string = localPath = endpoint.getProtocol() != null ? Servers.getLocalPath(endpoint) : endpoint.getFile();
            if (localPath != null) {
                Object object = Registry.get(localPath);
                this.server = ((IUDDIServerHolder)object).getUDDIServer();
                this.publicationHandler = new SOAPLocalTransport(new XURL(localPath), (IService)object);
            } else {
                this.publicationHandler = new SOAPToHTTP(endpoint);
            }
        }
        catch (Exception exception) {
            throw new UDDIException(exception.getMessage(), "2.0");
        }
    }

    public String getPublicationURL() {
        return this.publicationURL;
    }

    public SOAPMessage invokeInquiry(SOAPMessage message, Context messageContext) throws RemoteException, SecurityException {
        return this.inquiryHandler.handle(message, messageContext);
    }

    public SOAPMessage invokePublication(SOAPMessage message, Context messageContext) throws RemoteException, SecurityException {
        return this.publicationHandler.handle(message, messageContext);
    }

    private Object invoke(ICommand command) throws UDDIException {
        if (command.needsAuthorization() && this.authorization == null && this.user != null && this.password != null) {
            this.authorization = this.getAuthorization();
        }
        if (this.isLocal()) {
            return this.invokeLocal(command);
        }
        return this.invokeRemote(command);
    }

    private Object invokeLocal(ICommand command) throws UDDIException {
        String version = command.getVersion();
        try {
            return this.server.invoke(command, this.authorization);
        }
        catch (UDDIException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new UDDIException(exception, version);
        }
    }

    private Object invokeRemote(ICommand command) throws UDDIException {
        String version = command.getVersion();
        try {
            LiteralWriter writer = new LiteralWriter();
            command.write(writer);
            if (command.needsAuthorization() && this.authorization != null) {
                writer.getElement().insertElement("authInfo").setString(this.authorization.getToken());
            }
            ISOAPHandler handler = command instanceof IInquiryCommand ? this.inquiryHandler : this.publicationHandler;
            SOAPMessage request = new SOAPMessage();
            writer.writeAttribute("generic", version);
            writer.writeNamespace("", version.equals("1.0") ? "urn:uddi-org:api" : "urn:uddi-org:api_v2");
            Document document = new Document();
            Element envelope = document.newRoot();
            envelope.setNamespace("", "http://schemas.xmlsoap.org/soap/envelope/");
            envelope.setName("Envelope");
            Element body = envelope.addElement("Body");
            body.addElement(writer.getElement());
            request.setDocument(document);
            if (Log.isLogging(IGLUELoggingConstants.SOAP_EVENT)) {
                Log.log(IGLUELoggingConstants.SOAP_EVENT, (Object)("request to " + handler + "\n" + request + "\n"));
            }
            request.addMIMEHeader("SOAPAction", "\"\"");
            SOAPMessage response = handler.handle(request, this.context);
            if (Log.isLogging(IGLUELoggingConstants.SOAP_EVENT)) {
                Log.log(IGLUELoggingConstants.SOAP_EVENT, (Object)("response from " + handler + "\n" + response + "\n"));
            }
            Element result = response.getBody().getFirstElement();
            if (response.isException()) {
                throw new UDDIException(result, version);
            }
            LiteralReader reader = new LiteralReader(result);
            ISerializable message = Messages.newInstance(reader.readName());
            message.read(reader);
            return message;
        }
        catch (UDDIException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new UDDIException(exception, version);
        }
    }

    public BusinessInfos findBusinesses(FindBusinesses query) throws UDDIException {
        return (BusinessInfos)this.invoke(query);
    }

    public BusinessInfos findBusinesses(Name[] names, Identifier[] identifiers, Category[] categories, String[] tModelKeys, DiscoveryURL[] discoveryURLs, Qualifier qualifier) throws UDDIException {
        return this.findBusinesses(new FindBusinesses(names, identifiers, categories, tModelKeys, discoveryURLs, qualifier));
    }

    public Businesses getBusinesses(String[] businessKeys) throws UDDIException {
        return (Businesses)this.invoke(new GetBusinesses(businessKeys));
    }

    public Business getBusiness(String businessKey) throws UDDIException {
        return this.getBusinesses((String[])new String[]{businessKey}).list[0];
    }

    public Businesses getBusinessesExtended(String[] businessKeys) throws UDDIException {
        return (Businesses)this.invoke(new GetBusinessesExtended(businessKeys));
    }

    public Business getBusinessExtended(String businessKey) throws UDDIException {
        return this.getBusinessesExtended((String[])new String[]{businessKey}).list[0];
    }

    public RelatedBusinessInfos findRelatedBusinesses(FindRelatedBusinesses query) throws UDDIException {
        return (RelatedBusinessInfos)this.invoke(query);
    }

    public RelatedBusinessInfos findRelatedBusinesses(String businessKey, Identifier keyedReference, Qualifier qualifier) throws UDDIException {
        return this.findRelatedBusinesses(new FindRelatedBusinesses(businessKey, keyedReference, qualifier));
    }

    public ServiceInfos findServices(FindServices query) throws UDDIException {
        return (ServiceInfos)this.invoke(query);
    }

    public ServiceInfos findServices(String businessKey, Name[] names, Category[] categories, String[] tModelKeys, Qualifier qualifier) throws UDDIException {
        return this.findServices(new FindServices(businessKey, names, categories, tModelKeys, qualifier));
    }

    public Services getServices(String[] serviceKeys) throws UDDIException {
        return (Services)this.invoke(new GetServices(serviceKeys));
    }

    public Service getService(String serviceKey) throws UDDIException {
        return this.getServices((String[])new String[]{serviceKey}).list[0];
    }

    public Bindings findBindings(FindBindings query) throws UDDIException {
        return (Bindings)this.invoke(query);
    }

    public Bindings findBindings(String serviceKey, String[] tModelKeys, Qualifier qualifier) throws UDDIException {
        return this.findBindings(new FindBindings(serviceKey, tModelKeys, qualifier));
    }

    public Bindings getBindings(String[] bindingKeys) throws UDDIException {
        return (Bindings)this.invoke(new GetBindings(bindingKeys));
    }

    public Binding getBinding(String bindingKey) throws UDDIException {
        return this.getBindings((String[])new String[]{bindingKey}).list[0];
    }

    public TModelInfos findTModels(FindTModels query) throws UDDIException {
        return (TModelInfos)this.invoke(query);
    }

    public TModelInfos findTModels(String name, Identifier[] identifiers, Category[] categories, Qualifier qualifier) throws UDDIException {
        return this.findTModels(new FindTModels(name, identifiers, categories, qualifier));
    }

    public TModels getTModels(String[] tModelKeys) throws UDDIException {
        return (TModels)this.invoke(new GetTModels(tModelKeys));
    }

    public TModel getTModel(String tModelKey) throws UDDIException {
        return this.getTModels((String[])new String[]{tModelKey}).list[0];
    }

    public OperationalInfos getOperationalInfo(String[] keys) throws UDDIException {
        return (OperationalInfos)this.invoke(new GetOperationalInfo(keys));
    }

    public Businesses saveBusinesses(Business[] businesses) throws UDDIException {
        return (Businesses)this.invoke(new SaveBusinesses(businesses));
    }

    public Business saveBusiness(Business business) throws UDDIException {
        return this.saveBusinesses((Business[])new Business[]{business}).list[0];
    }

    public Businesses saveBusinesses(String[] urls) throws UDDIException {
        return (Businesses)this.invoke(new SaveBusinesses(urls));
    }

    public Business saveBusiness(String url) throws UDDIException {
        return this.saveBusinesses((String[])new String[]{url}).list[0];
    }

    public void deleteBusinesses(String[] businessKeys) throws UDDIException {
        this.invoke(new DeleteBusinesses(businessKeys));
    }

    public void deleteBusiness(String businessKey) throws UDDIException {
        this.deleteBusinesses(new String[]{businessKey});
    }

    public Services saveServices(Service[] services) throws UDDIException {
        return (Services)this.invoke(new SaveServices(services));
    }

    public Service saveService(Service service) throws UDDIException {
        return this.saveServices((Service[])new Service[]{service}).list[0];
    }

    public void deleteServices(String[] serviceKeys) throws UDDIException {
        this.invoke(new DeleteServices(serviceKeys));
    }

    public void deleteService(String serviceKey) throws UDDIException {
        this.deleteServices(new String[]{serviceKey});
    }

    public Bindings saveBindings(Binding[] bindings) throws UDDIException {
        return (Bindings)this.invoke(new SaveBindings(bindings));
    }

    public Binding saveBinding(Binding binding) throws UDDIException {
        return this.saveBindings((Binding[])new Binding[]{binding}).list[0];
    }

    public void deleteBindings(String[] bindingKeys) throws UDDIException {
        this.invoke(new DeleteBindings(bindingKeys));
    }

    public void deleteBinding(String bindingKey) throws UDDIException {
        this.deleteBindings(new String[]{bindingKey});
    }

    public TModels saveTModels(TModel[] tModels) throws UDDIException {
        return (TModels)this.invoke(new SaveTModels(tModels));
    }

    public TModel saveTModel(TModel tModel) throws UDDIException {
        return this.saveTModels((TModel[])new TModel[]{tModel}).list[0];
    }

    public TModels saveTModels(String[] urls) throws UDDIException {
        return (TModels)this.invoke(new SaveTModels(urls));
    }

    public TModel saveTModel(String url) throws UDDIException {
        return this.saveTModels((String[])new String[]{url}).list[0];
    }

    public void deleteTModels(String[] tModelKeys) throws UDDIException {
        this.invoke(new DeleteTModels(tModelKeys));
    }

    public void deleteTModel(String tModelKey) throws UDDIException {
        this.deleteTModels(new String[]{tModelKey});
    }

    public void addAssertions(Assertion[] assertions) throws UDDIException {
        this.invoke(new AddAssertions(assertions));
    }

    public void deleteAssertions(Assertion[] assertions) throws UDDIException {
        this.invoke(new DeleteAssertions(assertions));
    }

    public Assertions getAssertions() throws UDDIException {
        return (Assertions)this.invoke(new GetAssertions());
    }

    public Assertions setAssertions(Assertion[] assertions) throws UDDIException {
        return (Assertions)this.invoke(new SetAssertions(assertions));
    }

    public AssertionStatusReport getAssertionStatusReport(String status) throws UDDIException {
        return (AssertionStatusReport)this.invoke(new GetAssertionStatusReport(status));
    }

    public Registered getRegistered() throws UDDIException {
        return (Registered)this.invoke(new GetRegistered());
    }

    public Authorization getAuthorization(String user, String password) throws UDDIException {
        return (Authorization)this.invoke(new GetAuthorization(user, password));
    }

    public Authorization getAuthorization() throws UDDIException {
        if (this.authorization == null) {
            this.authorization = this.getAuthorization(this.user, this.password);
        }
        return this.authorization;
    }

    public void discardAuthorization() throws UDDIException {
        this.invoke(new DiscardAuthorization());
    }

    public void deleteSubscription(String[] subscriptionKeys) throws UDDIException {
        this.invoke(new DeleteSubscriptions(subscriptionKeys));
    }

    public SubscriptionResults getSubscriptionResults(GetSubscriptionResults query) throws UDDIException {
        return (SubscriptionResults)this.invoke(query);
    }

    public Subscriptions getSubscriptions() throws UDDIException {
        return (Subscriptions)this.invoke(new GetSubscriptions());
    }

    public Duration saveSubscriptions(Subscription[] subscriptions) throws UDDIException {
        return (Duration)this.invoke(new SaveSubscriptions(subscriptions));
    }

    static {
        Product.startup();
    }
}

