/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server;

import electric.server.http.IServletHandler;
import electric.server.http.ServletServer;
import electric.servlet.util.HTTPServletUtil;
import electric.uddi.Binding;
import electric.uddi.Business;
import electric.uddi.IUDDIConstants;
import electric.uddi.Service;
import electric.uddi.TModel;
import electric.uddi.server.UDDIServer;
import electric.util.http.IHTTPConstants;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class UDDIServlet
implements IUDDIConstants,
IServletHandler,
IHTTPConstants {
    private UDDIServer server;

    UDDIServlet(UDDIServer server) {
        this.server = server;
    }

    public void init(ServletServer server) {
    }

    public synchronized boolean service(ServletServer server, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getMethod().equalsIgnoreCase("GET")) {
            return false;
        }
        IWriter writer = this.getWriter(request);
        response.setHeader("Server", IHTTPConstants.SERVER_TYPE);
        if (writer == null) {
            response.sendError(404);
        } else {
            response.setStatus(200);
            response.setContentType("text/xml");
            writer.writeAttribute("generic", "2.0");
            writer.writeNamespace("", "urn:uddi-org:api_v2");
            byte[] bytes = writer.getElement().toString().getBytes();
            HTTPServletUtil.writeContent(request, response, bytes);
        }
        return true;
    }

    private IWriter getWriter(HttpServletRequest request) throws IOException {
        String key = null;
        key = request.getParameter("businessKey");
        if (key != null) {
            return this.writeBusiness(key);
        }
        key = request.getParameter("serviceKey");
        if (key != null) {
            return this.writeService(key);
        }
        key = request.getParameter("bindingKey");
        if (key != null) {
            return this.writeBinding(key);
        }
        key = request.getParameter("tModelKey");
        if (key != null) {
            return this.writeTModel(key);
        }
        return null;
    }

    private IWriter writeBusiness(String businessKey) throws IOException {
        Business business = this.server.readBusiness(businessKey);
        if (business == null) {
            return null;
        }
        LiteralWriter writer = new LiteralWriter("businessDetail");
        business.write(writer, true, false, false);
        return writer;
    }

    private IWriter writeService(String serviceKey) throws IOException {
        Service service = this.server.readService(serviceKey);
        if (service == null) {
            return null;
        }
        LiteralWriter writer = new LiteralWriter("serviceDetail");
        service.write(writer, true, false);
        return writer;
    }

    private IWriter writeBinding(String bindingKey) throws IOException {
        Binding binding = this.server.readBinding(bindingKey);
        if (binding == null) {
            return null;
        }
        LiteralWriter writer = new LiteralWriter("bindingDetail");
        binding.write(writer);
        return writer;
    }

    private IWriter writeTModel(String tModelKey) throws IOException {
        TModel tModel = this.server.readTModel(tModelKey);
        if (tModel == null) {
            return null;
        }
        LiteralWriter writer = new LiteralWriter("tModelDetail");
        tModel.write(writer);
        return writer;
    }
}

