/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server.sql;

import electric.sql.SQLClient;
import electric.uddi.Address;
import electric.uddi.AddressLine;
import electric.uddi.Contact;
import electric.uddi.Description;
import electric.uddi.Email;
import electric.uddi.Phone;
import electric.uddi.server.sql.DescriptionTable;
import electric.uddi.server.sql.IDTable;
import electric.util.array.ArrayUtil;
import java.sql.ResultSet;
import java.sql.SQLException;

class ContactTable {
    private SQLClient sqlClient;
    private DescriptionTable descriptionTable;

    ContactTable(SQLClient command) {
        this.sqlClient = command;
        this.descriptionTable = new DescriptionTable(this.sqlClient);
    }

    void insert(Contact[] contacts, String businessKey) throws SQLException {
        String[] inserts = new String[contacts.length];
        int i = 0;
        while (i < contacts.length) {
            int contactID = new IDTable(this.sqlClient).getID("CONTACT");
            String name = contacts[i].getPersonName();
            String useType = contacts[i].getUseType();
            Phone[] phones = contacts[i].getPhones();
            Email[] emails = contacts[i].getEmails();
            Address[] addresses = contacts[i].getAddresses();
            Description[] descriptions = contacts[i].getDescriptions();
            inserts[i] = "INSERT into contact ( CONTACTID, NAME, USE_TYPE, BUSINESS_KEY ) VALUES ( " + contactID + ", '" + name + "','" + useType + "','" + businessKey + "')";
            this.sqlClient.insert(inserts[i]);
            this.savePhones(phones, contactID);
            this.saveEmails(emails, contactID);
            this.saveAddresses(addresses, contactID);
            this.saveDescriptions(descriptions, String.valueOf(contactID));
            ++i;
        }
    }

    private void savePhones(Phone[] phones, int contactID) throws SQLException {
        String[] inserts = new String[phones.length];
        int i = 0;
        while (i < phones.length) {
            String number = phones[i].getNumber();
            String useType = phones[i].getUseType();
            inserts[i] = "INSERT into phone ( CONTACTID, PHONE_NUMBER, USE_TYPE ) VALUES ( " + contactID + ", '" + number + "','" + useType + "')";
            this.sqlClient.insert(inserts[i]);
            ++i;
        }
    }

    private void saveEmails(Email[] emails, int contactID) throws SQLException {
        String[] inserts = new String[emails.length];
        int i = 0;
        while (i < emails.length) {
            String address = emails[i].getAddress();
            String useType = emails[i].getUseType();
            inserts[i] = "INSERT into email ( ADDRESS, CONTACTID, USE_TYPE ) VALUES ( '" + address + "', " + contactID + ", '" + useType + "')";
            this.sqlClient.insert(inserts[i]);
            ++i;
        }
    }

    private void saveAddresses(Address[] addresses, int contactID) throws SQLException {
        AddressLine[] lines = new AddressLine[]{};
        String[] inserts = new String[addresses.length];
        int i = 0;
        while (i < addresses.length) {
            int addressID = new IDTable(this.sqlClient).getID("ADDRESS");
            String useType = addresses[i].getUseType();
            String sortCode = addresses[i].getSortCode();
            lines = addresses[i].getAddressLines();
            inserts[i] = "INSERT into address ( ADDRESSID, CONTACTID, USE_TYPE, SORT_CODE ) VALUES ( " + addressID + ", " + contactID + ", '" + useType + "','" + sortCode + "' )";
            this.sqlClient.insert(inserts[i]);
            this.saveAddressLines(lines, addressID);
            ++i;
        }
    }

    private void saveDescriptions(Description[] descriptions, String contactID) throws SQLException {
        this.descriptionTable.insert(descriptions, contactID);
    }

    private void saveAddressLines(AddressLine[] lines, int id) throws SQLException {
        String[] inserts = new String[lines.length];
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].getText();
            inserts[i] = "INSERT into address_lines ( ADDRESSID, LINE ) VALUES ( " + id + ", '" + line + "' )";
            this.sqlClient.insert(inserts[i]);
            ++i;
        }
    }

    Contact[] select(String businessKey) throws SQLException {
        Contact[] contacts = new Contact[]{};
        String query = "SELECT CONTACTID, NAME, USE_TYPE from contact where BUSINESS_KEY = '" + businessKey + "'";
        ResultSet rs = this.sqlClient.select(query);
        while (rs.next()) {
            int id = rs.getInt(1);
            String name = rs.getString(2);
            String useType = rs.getString(3);
            Contact contact = new Contact(name);
            contact.setUseType(useType);
            contact = this.selectPhones(id, contact);
            contact = this.selectEmails(id, contact);
            contact = this.selectAddresses(id, contact);
            Description[] descriptions = this.descriptionTable.select(String.valueOf(id));
            contact.setDescriptions(descriptions);
            contacts = (Contact[])ArrayUtil.addElement(contacts, contact);
        }
        return contacts;
    }

    private Contact selectPhones(int id, Contact contact) throws SQLException {
        String query = "SELECT PHONE_NUMBER, USE_TYPE from phone where CONTACTID = " + id;
        ResultSet rs = this.sqlClient.select(query);
        while (rs.next()) {
            String number = rs.getString(1);
            String useType = rs.getString(2);
            Phone phone = new Phone(number);
            phone.setUseType(useType);
            contact.addPhone(phone);
        }
        return contact;
    }

    private Contact selectEmails(int id, Contact contact) throws SQLException {
        String query = "SELECT ADDRESS, USE_TYPE  from email where CONTACTID = " + id;
        ResultSet rs = this.sqlClient.select(query);
        while (rs.next()) {
            String address = rs.getString(1);
            String useType = rs.getString(2);
            Email email = new Email(address);
            email.setUseType(useType);
            contact.addEmail(email);
        }
        return contact;
    }

    private Contact selectAddresses(int id, Contact contact) throws SQLException {
        AddressLine[] lines = new AddressLine[]{};
        String query = "SELECT ADDRESSID, USE_TYPE, SORT_CODE from address where CONTACTID = " + id;
        ResultSet rs = this.sqlClient.select(query);
        while (rs.next()) {
            int addressID = rs.getInt(1);
            String useType = rs.getString(2);
            String sortCode = rs.getString(3);
            lines = this.selectAddressLines(addressID);
            Address address = new Address(lines);
            address.setUseType(useType);
            address.setSortCode(sortCode);
            contact.addAddress(address);
        }
        return contact;
    }

    private AddressLine[] selectAddressLines(int id) throws SQLException {
        AddressLine[] lines = new AddressLine[]{};
        String query = "SELECT LINE from address_lines where ADDRESSID = " + id;
        ResultSet rs = this.sqlClient.select(query);
        while (rs.next()) {
            AddressLine line = new AddressLine(rs.getString(1));
            lines = (AddressLine[])ArrayUtil.addElement(lines, line);
        }
        return lines;
    }

    void delete(String businessKey) throws SQLException {
        String query = "SELECT CONTACTID from contact where BUSINESS_KEY = '" + businessKey + "'";
        ResultSet rs = this.sqlClient.select(query);
        while (rs.next()) {
            int id = rs.getInt(1);
            query = "SELECT ADDRESSID from address where CONTACTID = " + id;
            ResultSet rs2 = this.sqlClient.select(query);
            while (rs2.next()) {
                int addressid = rs2.getInt(1);
                String sql = "DELETE from address_lines where ADDRESSID = " + addressid;
                this.sqlClient.delete(sql);
            }
            String[] stmts = new String[]{"DELETE from contact where CONTACTID = " + id, "DELETE from email where CONTACTID = " + id, "DELETE from phone where CONTACTID = " + id, "DELETE from address where CONTACTID = " + id};
            this.sqlClient.execute(stmts);
        }
    }
}

