/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server.xdb;

import electric.uddi.server.xdb.TypeSelector;
import electric.util.dictionary.DictionaryElements;
import electric.util.dictionary.persistent.IPersistentDictionary;
import electric.util.string.Strings;
import electric.xdb.Data;
import electric.xdb.XDBException;
import electric.xdb.server.IXDBServer;
import electric.xdb.store.IDataSelector;
import java.util.Enumeration;
import java.util.Vector;

public class XDBDictionary
implements IPersistentDictionary {
    private IXDBServer server;
    private IDataSelector selector;
    private String prefix;

    public XDBDictionary(IXDBServer server, Class type) {
        this.server = server;
        this.selector = new TypeSelector(type);
        this.prefix = Strings.getLocalJavaName(type.getName()) + "_";
    }

    public void delete() {
    }

    public void clear() {
        try {
            this.server.removeDataForSelector(this.selector);
        }
        catch (XDBException exception) {}
    }

    public Enumeration elements() {
        return new DictionaryElements(this);
    }

    public Enumeration keys() {
        try {
            String[] keys = this.server.getKeysForSelector(this.selector);
            Vector<String> vector = new Vector<String>();
            int i = 0;
            while (i < keys.length) {
                vector.addElement(keys[i].substring(this.prefix.length()));
                ++i;
            }
            return vector.elements();
        }
        catch (XDBException exception) {
            return new Vector().elements();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        try {
            return this.server.getDataCountForSelector(this.selector);
        }
        catch (XDBException exception) {
            return 0;
        }
    }

    public Object get(Object key) {
        try {
            String keyString = this.getKey(key);
            Data data = this.server.getDataForKey(keyString);
            return data == null ? null : data.getObject();
        }
        catch (XDBException exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Object peek(Object key) {
        return this.get(key);
    }

    public Object put(Object key, Object value) {
        try {
            String keyString = this.getKey(key);
            Data oldData = this.server.getDataForKey(keyString);
            Data newData = new Data(keyString, value);
            this.server.addData(newData);
            return oldData;
        }
        catch (XDBException exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Object remove(Object key) {
        try {
            String keyString = this.getKey(key);
            Data oldData = this.server.getDataForKey(keyString);
            this.server.removeDataForKey(keyString);
            return oldData;
        }
        catch (XDBException exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Object load(Object key) {
        return this.get(key);
    }

    private String getKey(Object key) {
        return this.prefix + key;
    }

    public boolean getEncoded() {
        return false;
    }

    public void setEncoded(boolean encoded) {
    }

    public void setSync(boolean flag) {
    }

    public boolean getSync() {
        return false;
    }

    public void sync() {
    }
}

