/*
 * Decompiled with CFR 0.152.
 */
package electric.util.classpath;

import electric.util.Context;
import electric.util.array.ArrayUtil;
import java.util.StringTokenizer;

public class ClassPath {
    private static final String CLASSPATH = Context.getSystemProperty("java.class.path");
    private static final String PATH_SEPARATOR = Context.getSystemProperty("path.separator");

    public static String getJarPath(String jarFilename) {
        if (CLASSPATH == null) {
            return null;
        }
        String[] classpaths = ClassPath.getClassPaths();
        int i = 0;
        while (i < classpaths.length) {
            if (classpaths[i].toLowerCase().endsWith(jarFilename.toLowerCase())) {
                return classpaths[i];
            }
            ++i;
        }
        return null;
    }

    public static String[] getClassPaths() {
        String[] paths = new String[]{};
        StringTokenizer tokenizer = new StringTokenizer(CLASSPATH, PATH_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            paths = (String[])ArrayUtil.addElement(paths, tokenizer.nextToken());
        }
        return paths;
    }
}

