/*
 * Decompiled with CFR 0.152.
 */
package electric.util.classpath;

import electric.util.array.ArrayUtil;
import electric.util.classpath.IClassPathEventListener;
import electric.util.classpath.IClassPathSource;
import java.io.File;

public class ClassPathSource
implements IClassPathSource,
IClassPathEventListener {
    private String[] classPaths = new String[0];
    private String[] ignoreList = new String[0];

    public String[] getClassPath() {
        return this.classPaths;
    }

    public String[] getIgnoreList() {
        return this.ignoreList;
    }

    public void addToClassPath(String path) {
        path = new File(path).getAbsolutePath();
        String newPath = path.toLowerCase();
        int i = 0;
        while (i < this.ignoreList.length) {
            if (newPath.startsWith(this.ignoreList[i])) {
                return;
            }
            ++i;
        }
        this.classPaths = (String[])ArrayUtil.addElement(this.classPaths, path);
    }

    public void removeFromClassPath(String path) {
        path = new File(path).getAbsolutePath().toLowerCase();
        int i = 0;
        while (i < this.ignoreList.length) {
            if (path.startsWith(this.ignoreList[i])) {
                return;
            }
            ++i;
        }
        this.classPaths = (String[])ArrayUtil.removeElement(this.classPaths, path);
    }

    public void addToIgnoreList(String path) {
        path = new File(path).getAbsolutePath().toLowerCase();
        this.ignoreList = (String[])ArrayUtil.addElement(this.ignoreList, path);
    }

    public void classesAdded(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.addToClassPath(files[i].getAbsolutePath());
            ++i;
        }
    }

    public void classesRemoved(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.removeFromClassPath(files[i].getAbsolutePath());
            ++i;
        }
    }

    public void classesModified(File[] files) {
    }
}

