/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dictionary.persistent;

import electric.util.WrappedException;
import electric.util.dictionary.persistent.IEntry;
import electric.util.dictionary.persistent.PersistentDictionary;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.ParseException;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.encoded.EncodedReader;
import electric.xml.io.encoded.EncodedWriter;
import electric.xml.io.literal.LiteralReader;
import electric.xml.io.literal.LiteralWriter;
import electric.xml.io.schema.SchemaProperties;
import java.io.File;
import java.util.Date;

final class Handle
implements ILoggingConstants {
    private PersistentDictionary dictionary;
    private String key;
    private boolean hasFile;
    private Object value;
    private long lastModifiedTime;

    Handle(PersistentDictionary dictionary, String key, boolean hasFile) {
        this.dictionary = dictionary;
        this.key = key;
        this.hasFile = hasFile;
    }

    public String toString() {
        return "Handle( " + this.key + ", " + this.value + " )";
    }

    public String getKey() {
        return this.key;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean hasFile() {
        return this.hasFile;
    }

    Object get() throws WrappedException {
        if (this.value == null && this.hasFile) {
            this.value = this.load();
        }
        return this.value;
    }

    Object peek() throws WrappedException {
        return this.value;
    }

    Object load() throws WrappedException {
        if (this.value instanceof IEntry) {
            return ((IEntry)this.value).loadEntry();
        }
        try {
            File file = this.getXMLFile();
            this.lastModifiedTime = file.lastModified();
            return this.newReader().readObject("value");
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "error loading object with key " + this.key + " from persistent dictionary", exception);
            }
            throw new WrappedException(exception);
        }
    }

    private IReader newReader() throws ParseException {
        if (this.dictionary.getEncoded()) {
            return new EncodedReader(new Document(this.getXMLFile()));
        }
        return new LiteralReader(new Document(this.getXMLFile()));
    }

    void reload() throws WrappedException {
        this.value = this.load();
    }

    Object put(Object value) throws WrappedException {
        Object previous = this.get();
        this.value = value;
        this.save();
        return previous;
    }

    void save() throws WrappedException {
        if (this.value instanceof IEntry) {
            ((IEntry)this.value).putEntry();
            return;
        }
        try {
            IWriter writer = this.newWriter();
            writer.writeAttribute("version", Integer.toString(1));
            writer.writeAttribute("lastModified", new Date().toString());
            writer.writeObject("value", this.value);
            File file = this.getXMLFile();
            file.delete();
            writer.getDocument().write(file);
            this.lastModifiedTime = file.lastModified();
            this.hasFile = true;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "error saving object " + this.value + " to persistent dictionary", exception);
            }
            throw new WrappedException(exception);
        }
    }

    private IWriter newWriter() {
        if (this.dictionary.getEncoded()) {
            return new EncodedWriter("file", SchemaProperties.getDefaultSchema(), "http://schemas.xmlsoap.org/soap/encoding/");
        }
        return new LiteralWriter("file");
    }

    Object remove() throws WrappedException {
        Object previous = this.get();
        this.delete();
        return previous;
    }

    void delete() {
        if (this.value instanceof IEntry) {
            ((IEntry)this.value).removedEntry();
        } else {
            this.getXMLFile().delete();
            this.hasFile = false;
        }
        this.value = null;
    }

    File getXMLFile() {
        String filename = Strings.toFilename(this.key);
        return new File(this.dictionary.getRoot() + File.separator + filename + ".xml");
    }
}

