/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dictionary.persistent;

import electric.util.dictionary.persistent.IPersistentDictionary;
import java.lang.ref.WeakReference;
import java.util.Vector;

public final class Sync
implements Runnable {
    private static final Vector dictionaries = new Vector();
    private static Sync sync = null;
    private int cycle;

    Sync(int cycle) {
        this.cycle = cycle;
    }

    public static synchronized void setSyncCycle(int milliseconds) {
        if (sync == null && milliseconds > 0) {
            sync = new Sync(milliseconds);
            Thread thread = new Thread(sync);
            thread.setDaemon(true);
            thread.start();
        } else if (sync != null) {
            Sync.sync.cycle = milliseconds;
        }
    }

    public static synchronized void addDictionary(IPersistentDictionary dictionary) {
        dictionaries.addElement(new WeakReference<IPersistentDictionary>(dictionary));
    }

    public static synchronized void removeDictionary(IPersistentDictionary dictionary) {
        int i = 0;
        while (i < dictionaries.size()) {
            if (((WeakReference)dictionaries.elementAt(i)).get() == dictionary) {
                dictionaries.removeElementAt(i);
                return;
            }
            ++i;
        }
    }

    public void run() {
        while (this.cycle > 0) {
            try {
                Thread.sleep(this.cycle);
                this.sync();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void sync() {
        int i = 0;
        while (i < dictionaries.size()) {
            WeakReference reference = (WeakReference)dictionaries.elementAt(i);
            IPersistentDictionary dictionary = (IPersistentDictionary)reference.get();
            if (dictionary == null) {
                dictionaries.removeElementAt(i);
                continue;
            }
            dictionary.sync();
            ++i;
        }
    }
}

