/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dictionary.sql;

import electric.sql.mapping.ObjectMapper;
import electric.util.WrappedException;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.sql.SQLException;

final class RowHandle
implements ILoggingConstants {
    private ObjectMapper mapper;
    private String tablename;
    private String key;
    private boolean hasRow;
    private Object value;

    public RowHandle(ObjectMapper mapper, String tablename, String key, boolean hasRow) {
        this.mapper = mapper;
        this.tablename = tablename;
        this.key = key;
        this.hasRow = hasRow;
    }

    public String toString() {
        return "RowHandle( " + this.key + ", " + this.value + " )";
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasRow() {
        return this.hasRow;
    }

    Object get() throws WrappedException {
        if (this.value == null && this.hasRow) {
            this.value = this.load();
        }
        return this.value;
    }

    Object put(Object value) throws SQLException {
        Object previous = this.get();
        this.value = value;
        if (value.equals(previous)) {
            this.mapper.delete(this.key, this.tablename);
        }
        this.save();
        return previous;
    }

    Object load() throws WrappedException {
        try {
            Object object = this.mapper.select(this.key, this.tablename);
            return object;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "Unable to read object back from jdbc dictionary.", exception);
            }
            throw new WrappedException(exception);
        }
    }

    void save() throws SQLException {
        this.mapper.insert(this.value, this.tablename);
        this.hasRow = true;
    }

    Object peek() throws WrappedException {
        return this.value;
    }
}

