/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dictionary.transactional;

import electric.transaction.ITransactional;
import electric.transaction.Transaction;
import electric.transaction.TransactionException;
import electric.util.dictionary.DictionaryElements;
import electric.util.dictionary.IDictionary;
import electric.util.dictionary.persistent.IPersistentDictionary;
import electric.util.dictionary.transactional.Get;
import electric.util.dictionary.transactional.IOperation;
import electric.util.dictionary.transactional.Put;
import electric.util.dictionary.transactional.Remove;
import electric.util.dictionary.transactional.TransactionalDictionary;
import electric.util.dictionary.transactional.ViewEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;

final class View
implements IDictionary,
ITransactional {
    private TransactionalDictionary dictionary;
    private Transaction transaction;
    private Hashtable keyToOperation = new Hashtable();

    View(TransactionalDictionary dictionary, Transaction transaction) {
        this.dictionary = dictionary;
        this.transaction = transaction;
        transaction.addParticipant(this);
    }

    public IPersistentDictionary getPersistentDictionary() {
        return this.dictionary.getPersistentDictionary();
    }

    public IOperation getOperation(String key) {
        return (IOperation)this.keyToOperation.get(key);
    }

    public Enumeration getOperationKeys() {
        return this.keyToOperation.keys();
    }

    public synchronized Object get(Object key) throws IllegalArgumentException {
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("key must be a string");
        }
        IOperation operation = (IOperation)this.keyToOperation.get(key);
        if (operation == null) {
            operation = new Get(this.dictionary.load(key));
            this.keyToOperation.put(key, operation);
        }
        return operation.getObject();
    }

    public synchronized Object put(Object key, Object value) throws IllegalArgumentException {
        Object previous = this.get(key);
        this.keyToOperation.put(key, new Put(value));
        return previous;
    }

    public synchronized Object remove(Object key) throws IllegalArgumentException {
        Object previous = this.get(key);
        this.keyToOperation.put(key, new Remove());
        return previous;
    }

    public int size() {
        int count = 0;
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            ++count;
            enumeration.nextElement();
        }
        return count;
    }

    public boolean isEmpty() {
        return this.keys().hasMoreElements();
    }

    public Enumeration keys() {
        return new ViewEnumeration(this);
    }

    public Enumeration elements() {
        return new DictionaryElements(this);
    }

    public synchronized Object peek(Object key) throws IllegalArgumentException {
        IOperation operation = (IOperation)this.keyToOperation.get(key);
        if (operation != null) {
            return operation.getObject();
        }
        return this.dictionary.getPersistentDictionary().peek(key);
    }

    public void commit() throws TransactionException {
        IPersistentDictionary persistentDictionary = this.dictionary.getPersistentDictionary();
        Enumeration enumeration = this.keyToOperation.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            IOperation operation = (IOperation)this.keyToOperation.get(key);
            operation.commitTransaction(persistentDictionary, key);
        }
        this.dictionary.removeView(this.transaction);
    }

    public void rollback() throws TransactionException {
        this.dictionary.removeView(this.transaction);
    }
}

