/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dime;

import electric.util.array.ArrayUtil;
import electric.util.dime.DIMEUtils;
import electric.util.dime.IDIMEConstants;
import electric.util.http.IHTTPConstants;
import electric.util.io.ISource;
import electric.util.io.StreamSource;
import electric.util.mime.IMIMEConstants;
import electric.util.mime.MIMEData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Vector;

public class DIMEBuilder
implements IMIMEConstants,
IHTTPConstants,
IDIMEConstants {
    private static final byte[] paddingBytes = new byte[]{0, 0, 0, 0};
    private MIMEData[] records;
    private long contentLength = -1L;

    public DIMEBuilder(MIMEData[] records) {
        this.records = records;
    }

    public DIMEBuilder(MIMEData rootRecord, MIMEData[] records) {
        this.records = records != null ? records : new MIMEData[0];
        this.records = (MIMEData[])ArrayUtil.insertElement(this.records, rootRecord);
    }

    public synchronized long getContentLength() {
        return this.contentLength;
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.contentLength = 0L;
        Vector<InputStream> streams = new Vector<InputStream>();
        int i = 0;
        while (i < this.records.length) {
            MIMEData record = this.records[i];
            boolean b = i == 0;
            boolean e = i == this.records.length - 1;
            ByteArrayInputStream headerStream = this.writeHeaders(record, b, e);
            this.contentLength += (long)headerStream.available();
            ByteArrayInputStream paddingStream = DIMEBuilder.writePadding(record);
            this.contentLength += (long)paddingStream.available();
            streams.addElement(headerStream);
            streams.addElement(record.getInputStream());
            streams.addElement(paddingStream);
            this.contentLength += (long)record.getContentLength();
            ++i;
        }
        return new SequenceInputStream(streams.elements());
    }

    public ISource getSource() throws IOException {
        InputStream inputStream = this.getInputStream();
        return new StreamSource(inputStream, (int)this.contentLength, 0L);
    }

    private ByteArrayInputStream writeHeaders(MIMEData mimeData, boolean begin, boolean end) throws IOException {
        ByteArrayOutputStream ostr = new ByteArrayOutputStream();
        int messageBegin = 0;
        if (begin) {
            messageBegin = 1;
        }
        int messageEnd = 0;
        if (end) {
            messageEnd = 1;
        }
        int chunkFlag = 0;
        int vflag = 0;
        vflag |= 8;
        vflag |= messageBegin << 2 & 4;
        vflag |= messageEnd << 1 & 2;
        ostr.write(vflag |= chunkFlag);
        int typeFormat = mimeData.headers.getIntHeader("typeFormat");
        String contentType = mimeData.getContentType();
        if (typeFormat == -1) {
            if (contentType != null) {
                typeFormat = 1;
            } else {
                contentType = "";
            }
        }
        if (typeFormat == -1) {
            typeFormat = 3;
        }
        int typeFlag = typeFormat << 4 & 0xF0;
        ostr.write(typeFlag);
        String id = mimeData.headers.getHeader("Content-ID");
        if (id == null) {
            id = "";
        }
        if (id.startsWith("<") && id.endsWith(">")) {
            id = id.substring(1, id.length() - 1);
        }
        if (!id.startsWith("cid:")) {
            id = "cid:" + id;
        }
        DIMEUtils.writeShort(ostr, 0);
        DIMEUtils.writeShort(ostr, id.length());
        DIMEUtils.writeShort(ostr, contentType.length());
        DIMEUtils.writeInt(ostr, mimeData.getContentLength());
        int idPadding = DIMEUtils.calculatePadding(id.length());
        byte[] idBytes = id.getBytes("UTF8");
        ostr.write(idBytes);
        ostr.write(paddingBytes, 0, idPadding);
        int typePadding = DIMEUtils.calculatePadding(contentType.length());
        byte[] typeBytes = contentType.getBytes("UTF8");
        ostr.write(typeBytes);
        ostr.write(paddingBytes, 0, typePadding);
        byte[] headerBytes = ostr.toByteArray();
        return new ByteArrayInputStream(headerBytes);
    }

    private static ByteArrayInputStream writePadding(MIMEData mimeData) {
        int contentLength = mimeData.getContentLength();
        int padding = DIMEUtils.calculatePadding(contentLength);
        ByteArrayOutputStream bostr = new ByteArrayOutputStream(4);
        bostr.write(paddingBytes, 0, padding);
        byte[] paddingBytes = bostr.toByteArray();
        return new ByteArrayInputStream(paddingBytes);
    }
}

