/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dime;

import electric.glue.IGLUELoggingConstants;
import electric.util.Context;
import electric.util.dime.DIMEUtils;
import electric.util.dime.IDIMEConstants;
import electric.util.http.IHTTPConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.IDataHandler;
import electric.util.mime.IMIMEConstants;
import electric.util.mime.MIMEData;
import java.io.IOException;
import java.io.InputStream;

public class DIMEReader
implements IMIMEConstants,
IHTTPConstants,
IDIMEConstants,
IGLUELoggingConstants {
    private boolean hasMoreElements;
    private InputStream istr;
    private Context context;

    public DIMEReader(InputStream istr, Context context) {
        this.istr = istr;
        this.context = context;
        this.hasMoreElements = true;
    }

    public DIMEReader(InputStream istr) {
        this(istr, new Context());
    }

    public boolean hasMoreElements() {
        return this.hasMoreElements;
    }

    public MIMEData read() throws IOException {
        return this.read(null);
    }

    public MIMEData read(IDataHandler partHandler) throws IOException {
        byte vflag = (byte)this.istr.read();
        if (vflag == -1) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)"error in dime soap message reader");
            }
            this.hasMoreElements = false;
            return null;
        }
        int version = (vflag & 0xF8) >> 3;
        if (version != 1) {
            this.hasMoreElements = false;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)"wrong dime version in soap message, cannot process");
            }
        }
        int messageEnd = (vflag & 2) >> 1;
        byte type = (byte)this.istr.read();
        int typeFormat = (type & 0xF0) >> 4;
        short optionsLength = DIMEUtils.readShort(this.istr);
        short idLength = DIMEUtils.readShort(this.istr);
        short typeLength = DIMEUtils.readShort(this.istr);
        int dataLength = DIMEUtils.readInt(this.istr);
        int optionsPadding = DIMEUtils.calculatePadding(optionsLength);
        int totalOptionsLength = optionsLength + optionsPadding;
        int i = 0;
        while (i < totalOptionsLength) {
            this.istr.read();
            ++i;
        }
        int idPadding = DIMEUtils.calculatePadding(idLength);
        int totalIdLength = idLength + idPadding;
        byte[] idBytes = new byte[totalIdLength];
        int r = 0;
        while (r < totalIdLength - r) {
            r += this.istr.read(idBytes, r, totalIdLength - r);
        }
        String id = new String(idBytes, 0, (int)idLength, "UTF8");
        int typePadding = DIMEUtils.calculatePadding(typeLength);
        int totalTypeLength = typeLength + typePadding;
        byte[] typeBytes = new byte[totalTypeLength];
        r = 0;
        while (r < totalTypeLength) {
            r += this.istr.read(typeBytes, r, totalTypeLength - r);
        }
        String typeURI = new String(typeBytes, 0, (int)typeLength, "UTF8");
        MIMEData dimeData = new MIMEData();
        dimeData.setContentType(typeURI);
        dimeData.setContentLength(dataLength);
        Context bodyContext = null;
        if (partHandler != null) {
            bodyContext = new Context();
            bodyContext.setProperty("*/* dataHandler", partHandler);
        } else {
            bodyContext = this.context;
        }
        dimeData.readContent(this.istr, bodyContext);
        dimeData.setContentLabel(id);
        dimeData.headers.setHeader("Content-ID", id);
        dimeData.headers.setIntHeader("typeFormat", typeFormat);
        int dataPadding = DIMEUtils.calculatePadding(dataLength);
        byte[] paddingBytes = new byte[dataPadding];
        r = 0;
        while (r < dataPadding) {
            r += this.istr.read(paddingBytes, r, dataPadding - r);
        }
        this.hasMoreElements = messageEnd == 0;
        return dimeData;
    }
}

