/*
 * Decompiled with CFR 0.152.
 */
package electric.util.directory.monitored;

import electric.util.array.ArrayUtil;
import electric.util.directory.monitored.FileEvent;
import electric.util.file.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;

public class MonitoredDirectory {
    private File root;
    private FilenameFilter filter;
    private boolean recurse;
    private boolean preCache;
    private Hashtable subDirs = new Hashtable();
    private Hashtable entries = new Hashtable();

    MonitoredDirectory(File root, boolean recurse, FilenameFilter filter, boolean preCache) {
        this.root = root;
        this.filter = filter;
        this.recurse = recurse;
        this.preCache = preCache;
        if (preCache) {
            this.preCache();
        }
        if (recurse) {
            this.updateSubdirectories();
        }
    }

    private void updateSubdirectories() {
        File[] files = FileUtil.listFiles(this.root);
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory() && !this.subDirs.containsKey(files[i].getName())) {
                MonitoredDirectory subdir = new MonitoredDirectory(files[i], true, this.filter, this.preCache);
                this.subDirs.put(files[i].getName(), subdir);
            }
            ++i;
        }
    }

    public void removeSubDirectory(String filePath) {
        this.subDirs.remove(filePath);
    }

    public File getRoot() {
        return this.root;
    }

    protected void update(FileEvent fileEvent) {
        File file;
        if (this.recurse) {
            this.updateSubdirectories();
        }
        Hashtable files = this.getFiles();
        File[] removed = new File[]{};
        File[] modified = new File[]{};
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            String fileName = (String)enumeration.nextElement();
            file = (File)files.get(fileName);
            if (file == null) {
                removed = (File[])ArrayUtil.addElement(removed, new File(this.root, fileName));
            } else if (((Long)this.entries.get(fileName)).longValue() != file.lastModified()) {
                modified = (File[])ArrayUtil.addElement(modified, file);
            }
            files.remove(fileName);
        }
        int i = modified.length - 1;
        while (i >= 0) {
            file = modified[i];
            fileEvent.addModifiedFile(file);
            this.entries.put(file.getName(), new Long(file.lastModified()));
            --i;
        }
        int i2 = removed.length - 1;
        while (i2 >= 0) {
            File file2 = removed[i2];
            fileEvent.addRemovedFile(file2);
            this.entries.remove(file2.getName());
            if (file2.isDirectory()) {
                this.subDirs.remove(file2.getName());
            }
            --i2;
        }
        enum = files.keys();
        while (enum.hasMoreElements()) {
            String fileName = (String)enum.nextElement();
            File file3 = (File)files.get(fileName);
            this.entries.put(fileName, new Long(file3.lastModified()));
            fileEvent.addAddedFile(file3);
        }
        Enumeration enum2 = this.subDirs.elements();
        while (enum2.hasMoreElements()) {
            ((MonitoredDirectory)enum2.nextElement()).update(fileEvent);
        }
    }

    private Hashtable getFiles() {
        File[] files = FileUtil.listFiles(this.root, this.filter);
        Hashtable<String, File> table = new Hashtable<String, File>(files.length + 1);
        int i = 0;
        while (i < files.length) {
            table.put(files[i].getName(), files[i]);
            ++i;
        }
        return table;
    }

    private void preCache() {
        Hashtable files = this.getFiles();
        Enumeration enumeration = files.keys();
        while (enumeration.hasMoreElements()) {
            String filename = (String)enumeration.nextElement();
            File file = (File)files.get(filename);
            this.entries.put(filename, new Long(file.lastModified()));
        }
    }
}

