/*
 * Decompiled with CFR 0.152.
 */
package electric.util.encoding;

import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.UnsupportedEncodingException;

public class StringEncodings
implements ILoggingConstants {
    private static String PROTOCOL_ENCODING = "UTF8";
    private static String ASSUMED_ENCODING = "UTF8";

    public static String getProtocolEncoding() {
        return PROTOCOL_ENCODING;
    }

    public static void setProtocolEncoding(String protocolEncoding) {
        PROTOCOL_ENCODING = protocolEncoding;
    }

    public static String getAssumedEncoding() {
        return ASSUMED_ENCODING;
    }

    public static void setAssumedEncoding(String assumedEncoding) {
        ASSUMED_ENCODING = assumedEncoding;
    }

    public static String fromProtocolEncoding(byte[] bytes) {
        try {
            return new String(bytes, PROTOCOL_ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, exception.getMessage(), exception);
            }
            return null;
        }
    }

    public static String fromProtocolEncoding(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, PROTOCOL_ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, exception.getMessage(), exception);
            }
            return null;
        }
    }

    public static byte[] toProtocolEncoding(String header) {
        try {
            return header.getBytes(PROTOCOL_ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, exception.getMessage(), exception);
            }
            return null;
        }
    }

    public static String fromAssumedEncoding(byte[] bytes) {
        try {
            return new String(bytes, ASSUMED_ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, exception.getMessage(), exception);
            }
            return null;
        }
    }

    public static String fromAssumedEncoding(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, ASSUMED_ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, exception.getMessage(), exception);
            }
            return null;
        }
    }

    public static byte[] toAssumedEncoding(String header) {
        try {
            return header.getBytes(ASSUMED_ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, exception.getMessage(), exception);
            }
            return null;
        }
    }
}

