/*
 * Decompiled with CFR 0.152.
 */
package electric.util.fileloader.archive;

import electric.util.array.ArrayUtil;
import electric.util.fileloader.IFileEntry;
import electric.util.fileloader.IFileLoader;
import electric.util.fileloader.archive.ArchiveEntry;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.MethodLookup;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Set;
import javax.servlet.ServletContext;

public class ArchiveLoader
implements IFileLoader,
ILoggingConstants {
    private static final IFileEntry[] EMPTY_ARRAY = new IFileEntry[0];
    private ServletContext servletContext;
    private Method getResourcePathsMethod;
    static /* synthetic */ Class class$java$lang$String;

    public ArchiveLoader(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.initReflectAccess();
    }

    public IFileEntry getEntry(String path) throws IOException {
        URL url = this.servletContext.getResource(path);
        if (url == null) {
            url = this.servletContext.getResource(path.replace('\\', '/'));
        }
        if (url == null) {
            throw new FileNotFoundException("unable to locate resource " + path);
        }
        return new ArchiveEntry(path, url, false);
    }

    public IFileEntry[] getEntries(String path) throws IOException {
        Set resources;
        if (this.getResourcePathsMethod == null) {
            return EMPTY_ARRAY;
        }
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + '/';
        }
        if ((resources = this.servletContext.getResourcePaths(path)) == null) {
            return EMPTY_ARRAY;
        }
        Object[] paths = resources.toArray();
        IFileEntry[] entries = new IFileEntry[]{};
        int i = 0;
        while (i < paths.length) {
            IFileEntry entry = null;
            String entryPath = (String)paths[i];
            if (!entryPath.equalsIgnoreCase(path)) {
                if (entryPath.startsWith(path) && entryPath.charAt(path.length()) == '/') {
                    entryPath = path + entryPath.substring(path.length() + 1);
                }
                entry = entryPath.endsWith("/") ? new ArchiveEntry(entryPath, null, true) : this.getEntry(entryPath);
                entries = (IFileEntry[])ArrayUtil.addElement(entries, entry);
            }
            ++i;
        }
        return entries;
    }

    public boolean exists(String path) {
        URL url = null;
        if (!(path = path.replace('\\', '/')).startsWith("/")) {
            path = '/' + path;
        }
        try {
            url = this.servletContext.getResource(path);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return url == null;
    }

    public boolean isFileSourceHotDeployable() {
        return false;
    }

    private void initReflectAccess() {
        block2: {
            Class<?> servletContextClass = this.servletContext.getClass();
            try {
                this.getResourcePathsMethod = MethodLookup.getMethod(servletContextClass, "getResourcePaths", new Class[]{class$java$lang$String == null ? (class$java$lang$String = ArchiveLoader.class$("java.lang.String")) : class$java$lang$String});
            }
            catch (NoSuchMethodException exception) {
                if (!Log.isLogging(ILoggingConstants.WARNING_EVENT)) break block2;
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)"dynamic resource path discovery is not available - this is not a Servlet 2.3 container.\nuse <mapFile> and <serviceDescriptor> elements to preload application resources");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

