/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import java.io.IOException;
import java.io.Reader;

public final class FastBufferedReader
extends Reader {
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private static int defaultCharBufferSize = 8192;
    private Reader reader;
    private char[] buffer;
    private int nChars;
    private int nextChar;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private boolean markedSkipLF = false;

    public FastBufferedReader(Reader reader, int size) {
        super((Object)reader);
        if (size <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.reader = reader;
        this.buffer = new char[size];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public FastBufferedReader(Reader reader) {
        this(reader, defaultCharBufferSize);
    }

    private void fill() throws IOException {
        int n;
        int dst;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= this.buffer.length) {
                    System.arraycopy(this.buffer, this.markedChar, this.buffer, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    System.arraycopy(this.buffer, this.markedChar, ncb, 0, delta);
                    this.buffer = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = this.reader.read(this.buffer, dst, this.buffer.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    public int read() throws IOException {
        while (true) {
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
            if (!this.skipLF) break;
            this.skipLF = false;
            if (this.buffer[this.nextChar] != '\n') break;
            ++this.nextChar;
        }
        return this.buffer[this.nextChar++];
    }

    private int read1(char[] cbuf, int offset, int length) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (length >= this.buffer.length && this.markedChar <= -1 && !this.skipLF) {
                return this.reader.read(cbuf, offset, length);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.buffer[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n = Math.min(length, this.nChars - this.nextChar);
        System.arraycopy(this.buffer, this.nextChar, cbuf, offset, n);
        this.nextChar += n;
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public int read(char[] cbuf, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        n = this.read1(cbuf, offset, length);
        if (n > 0) ** GOTO lbl8
        return n;
        while ((n1 = this.read1(cbuf, offset + n, length - n)) > 0) {
            n += n1;
lbl8:
            // 2 sources

            if (n < length && this.reader.ready()) continue;
        }
        return n;
    }

    public long skip(long n) throws IOException {
        long r = n;
        while (r > 0L) {
            long d;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) break;
            if (this.skipLF) {
                this.skipLF = false;
                if (this.buffer[this.nextChar] == '\n') {
                    ++this.nextChar;
                }
            }
            if (r <= (d = (long)(this.nChars - this.nextChar))) {
                this.nextChar = (int)((long)this.nextChar + r);
                r = 0L;
                break;
            }
            r -= d;
            this.nextChar = this.nChars;
        }
        return n - r;
    }

    public boolean ready() throws IOException {
        return this.nextChar < this.nChars || this.reader.ready();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.readAheadLimit = readAheadLimit;
        this.markedChar = this.nextChar;
        this.markedSkipLF = this.skipLF;
    }

    public void reset() throws IOException {
        if (this.markedChar < 0) {
            throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
        }
        this.nextChar = this.markedChar;
        this.skipLF = this.markedSkipLF;
    }

    public void close() throws IOException {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.buffer = null;
    }
}

