/*
 * Decompiled with CFR 0.152.
 */
package electric.util.lex;

import electric.util.io.FastStringReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public final class Lex {
    public static final int SKIP_WS = 1;
    public static final int CONSUME = 2;
    public static final int INCLUDE = 4;
    public static final int EOF_OK = 8;
    public static final int QUOTES = 16;
    public static final int STRIP = 32;
    public static final int HTML = 64;
    public static final int COMMENTS = 128;
    static final int BUFFER_SIZE = 60;
    static final Hashtable substitutions = new Hashtable();
    private Reader reader;
    private String defaultDelimiters;
    private int defaultFlags;
    private int index = 0;
    private boolean eol;
    private int lineNumber = 1;
    private int charNumber = 0;
    private StringBuffer comment;
    private int[] window = null;

    public Lex(String string) {
        this(new FastStringReader(string));
    }

    public Lex(Reader reader) {
        this(reader, "", 1);
    }

    public Lex(String string, String defaultDelimiters, int defaultFlags) {
        this(new FastStringReader(string), defaultDelimiters, defaultFlags);
    }

    public Lex(Reader reader, String defaultDelimiters, int defaultFlags) {
        this.reader = reader;
        this.defaultDelimiters = defaultDelimiters;
        this.defaultFlags = defaultFlags;
        this.setWindow(60);
    }

    public String getComment() {
        return this.comment == null ? "" : this.comment.toString();
    }

    public void clearComment() {
        this.comment = null;
    }

    public String readToPattern(String pattern, int flags) throws IOException {
        StringBuffer buffer = new StringBuffer();
        if ((flags & 1) != 0) {
            this.skipWhitespace(flags);
        }
        char ch = pattern.charAt(0);
        int length = pattern.length();
        while (true) {
            int next;
            if ((next = this.peek()) == -1) {
                if ((flags & 8) == 0) {
                    throw new IOException("unexpected EOF while searching for '" + pattern + "'");
                }
                this.read();
                return buffer.toString();
            }
            if (next == ch) {
                if (length == 1) {
                    if ((flags & 4) != 0) {
                        buffer.append((char)next);
                    }
                    if ((flags & 2) != 0) {
                        this.read();
                    }
                    return buffer.toString();
                }
                int[] peekBuffer = new int[length];
                this.peek(peekBuffer);
                boolean match = true;
                int i = 1;
                while (i < length) {
                    if (peekBuffer[i] != pattern.charAt(i)) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (match) {
                    if ((flags & 2) != 0) {
                        int i2 = 0;
                        while (i2 < length) {
                            this.read();
                            ++i2;
                        }
                    }
                    if ((flags & 4) != 0) {
                        int i3 = 0;
                        while (i3 < length) {
                            buffer.append((char)peekBuffer[i3]);
                            ++i3;
                        }
                    }
                    return buffer.toString();
                }
            }
            if (next == 38 && (flags & 0x40) != 0) {
                this.readHTML(buffer);
                continue;
            }
            if ((next == 39 || next == 34) && (flags & 0x10) != 0) {
                this.readQuoted(buffer, next, flags);
                continue;
            }
            buffer.append((char)this.read());
        }
    }

    public String readToDelimiter(String delimiters, int flags) throws IOException {
        if ((flags & 1) != 0) {
            this.skipWhitespace(flags);
        }
        StringBuffer buffer = new StringBuffer();
        while (true) {
            int next;
            if ((next = this.peek()) == -1) {
                if (buffer.length() <= 0) {
                    throw new IOException("unexpected EOF");
                }
                this.read();
                return buffer.toString();
            }
            if (delimiters.indexOf(next) != -1) {
                if (buffer.length() == 0) {
                    buffer.append((char)this.read());
                }
                return buffer.toString();
            }
            if (Character.isWhitespace((char)next)) {
                return buffer.toString();
            }
            if (next == 38 && (flags & 0x40) != 0) {
                this.readHTML(buffer);
                continue;
            }
            if ((next == 39 || next == 34) && (flags & 0x10) != 0) {
                this.readQuoted(buffer, next, flags);
                continue;
            }
            buffer.append((char)this.read());
        }
    }

    public String readToDelimiter(String delimiters) throws IOException {
        return this.readToDelimiter(delimiters, this.defaultFlags);
    }

    public String readToken() throws IOException {
        return this.readToDelimiter(this.defaultDelimiters, this.defaultFlags);
    }

    public void readToken(String expected) throws IOException {
        String got = this.readToken();
        if (!expected.equals(got)) {
            throw new IOException("expected \"" + expected + "\", got \"" + got + "\"");
        }
    }

    public void readHTML(StringBuffer buffer) throws IOException {
        this.read();
        String special = this.readTo(59);
        try {
            if (special.startsWith("#x")) {
                buffer.append((char)Integer.parseInt(special.substring(2), 16));
            } else if (special.startsWith("#")) {
                buffer.append((char)Integer.parseInt(special.substring(1)));
            } else {
                String replacement = (String)substitutions.get(special);
                if (replacement != null) {
                    buffer.append(replacement);
                } else {
                    buffer.append('&');
                    buffer.append(special);
                    buffer.append(';');
                }
            }
        }
        catch (NumberFormatException exception) {
            throw new IOException("number format exception while parsing &" + special + ";");
        }
    }

    private void readQuoted(StringBuffer buffer, int quote, int flags) throws IOException {
        int c = this.read();
        if ((flags & 0x20) == 0) {
            buffer.append((char)c);
        }
        while ((c = this.read()) != -1) {
            if (c == quote) {
                if ((flags & 0x20) != 0) break;
                buffer.append((char)c);
                break;
            }
            buffer.append((char)c);
        }
    }

    public int readChar() throws IOException {
        this.skipWhitespace();
        int ch = this.read();
        if (ch == -1) {
            throw new IOException("unexpected EOF");
        }
        return ch;
    }

    public void readChar(int expected) throws IOException {
        int got = this.readChar();
        if (got != expected) {
            throw new IOException("expected '" + (char)expected + "', got '" + (char)got + "'");
        }
    }

    public String readTo(int ch) throws IOException {
        StringBuffer special = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.read()) == -1) {
                throw new IOException("could not find " + ch);
            }
            if (c == ch) break;
            special.append((char)c);
        }
        return special.toString();
    }

    public StringBuffer readWhitespace() throws IOException {
        return this.readWhitespace(this.defaultFlags);
    }

    public StringBuffer readWhitespace(int flags) throws IOException {
        StringBuffer buffer;
        block4: {
            buffer = null;
            while (true) {
                this.reader.mark(2);
                int ch = this.reader.read();
                if (Character.isWhitespace((char)ch)) {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                    }
                    this.reader.reset();
                    buffer.append((char)this.read());
                    continue;
                }
                if (ch != 47 || (flags & 0x80) == 0) break block4;
                ch = this.reader.read();
                this.reader.reset();
                if (ch == 47) {
                    this.readOneLineComment();
                    continue;
                }
                if (ch != 42) break;
                this.readMultiLineComment();
            }
            return buffer;
        }
        this.reader.reset();
        return buffer;
    }

    public void skipWhitespace() throws IOException {
        this.skipWhitespace(this.defaultFlags);
    }

    public void skipWhitespace(int flags) throws IOException {
        block3: {
            while (true) {
                this.reader.mark(2);
                int ch = this.reader.read();
                if (Character.isWhitespace((char)ch)) {
                    this.reader.reset();
                    this.read();
                    continue;
                }
                if (ch != 47 || (flags & 0x80) == 0) break block3;
                ch = this.reader.read();
                this.reader.reset();
                if (ch == 47) {
                    this.readOneLineComment();
                    continue;
                }
                if (ch != 42) break;
                this.readMultiLineComment();
            }
            return;
        }
        this.reader.reset();
    }

    private void readOneLineComment() throws IOException {
        if (this.comment == null) {
            this.comment = new StringBuffer();
        }
        this.comment.append(this.readToPattern("\n", 10));
    }

    private void readMultiLineComment() throws IOException {
        int ch;
        if (this.comment == null) {
            this.comment = new StringBuffer();
        }
        do {
            if ((ch = this.read()) == -1) {
                throw new IOException("missing */ on comment");
            }
            this.comment.append((char)ch);
        } while (ch != 42 || this.peek() != 47);
        ch = this.read();
        this.comment.append((char)ch);
    }

    public String peekString(int length) throws IOException {
        int[] array = new int[length];
        this.peek(array);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (array[i] == -1) break;
            buffer.append((char)array[i]);
            ++i;
        }
        return buffer.toString();
    }

    public boolean peekString(String string) throws IOException {
        return string.equals(this.peekString(string.length()));
    }

    public void peek(int[] buffer) throws IOException {
        this.reader.mark(buffer.length);
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = this.reader.read();
            ++i;
        }
        this.reader.reset();
    }

    public int peek() throws IOException {
        this.reader.mark(1);
        int next = this.reader.read();
        this.reader.reset();
        return next;
    }

    public void mark(int length) throws IOException {
        this.reader.mark(length);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public boolean eof() throws IOException {
        this.skipWhitespace();
        return this.peek() == -1;
    }

    public void skip(int length) throws IOException {
        int i = 0;
        while (i < length) {
            this.read();
            ++i;
        }
    }

    public String getLocation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("line ").append(this.lineNumber).append(", char ").append(this.charNumber);
        if (this.window == null) {
            return buffer.toString();
        }
        buffer.append(": ...");
        StringBuffer line = new StringBuffer();
        int count = 0;
        int start = this.index;
        while (count++ < this.charNumber) {
            if (start-- == 0) {
                start = 59;
            }
            if (this.window[start] == 10 || start == this.index) break;
            line.append((char)this.window[start]);
        }
        return buffer.append((Object)line.reverse()).toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int peekRead() throws IOException {
        return this.reader.read();
    }

    public int read() throws IOException {
        if (this.eol) {
            ++this.lineNumber;
            this.charNumber = 0;
        }
        int ch = this.reader.read();
        ++this.charNumber;
        boolean bl = this.eol = ch == 10;
        if (this.window != null) {
            this.window[this.index] = ch;
            if (++this.index == this.window.length) {
                this.index = 0;
            }
        }
        return ch;
    }

    public void setWindow(int length) {
        this.window = new int[length];
    }

    private static void initSubstitutions() {
        substitutions.put("apos", "'");
        substitutions.put("lt", "<");
        substitutions.put("gt", ">");
        substitutions.put("quot", "\"");
        substitutions.put("amp", "&");
    }

    static {
        Lex.initSubstitutions();
    }
}

