/*
 * Decompiled with CFR 0.152.
 */
package electric.util.log;

import electric.util.Context;
import electric.util.log.ILogger;
import electric.util.log.ILoggingConstants;
import electric.util.log.WriterLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Log {
    private static final Hashtable stringToCode = new Hashtable();
    private static final Hashtable codeToString = new Hashtable();
    private static final Hashtable nameToLogger = new Hashtable();
    private static long masks;
    private static Hashtable explicitLogging;

    private static void initLoggers() {
        Log.addLogger("default", new WriterLogger(ILoggingConstants.ERROR_EVENT | ILoggingConstants.COMMENT_EVENT));
        String logging = Context.getSystemProperty("electric.logging");
        if (logging != null) {
            StringTokenizer tokenizer = new StringTokenizer(logging, ", \t");
            while (tokenizer.hasMoreTokens()) {
                Log.startLogging(tokenizer.nextToken());
            }
            explicitLogging.clear();
        }
    }

    public static boolean isLogging(long mask) {
        return (masks & mask) != 0L;
    }

    public static boolean isLogging(String category) {
        return Log.isLogging(Log.getCode(category));
    }

    public static synchronized long getCode(String category) {
        Long code = (Long)stringToCode.get(category);
        if (code == null) {
            code = new Long(1L << stringToCode.size());
            stringToCode.put(category, code);
            codeToString.put(code, category);
        }
        return code;
    }

    public static synchronized String getCategory(long code) {
        return (String)codeToString.get(new Long(code));
    }

    static synchronized void recalcMasks() {
        masks = 0L;
        Enumeration enumeration = nameToLogger.elements();
        while (enumeration.hasMoreElements()) {
            masks |= ((ILogger)enumeration.nextElement()).getMask();
        }
    }

    public static synchronized ILogger getLogger(String name) {
        return (ILogger)nameToLogger.get(name);
    }

    public static synchronized void addLogger(String name, ILogger logger) {
        nameToLogger.put(name, logger);
        Log.recalcMasks();
    }

    public static synchronized void removeLogger(String name) {
        nameToLogger.remove(name);
        Log.recalcMasks();
    }

    public static synchronized void disableLogger(String name) {
        ILogger logger = (ILogger)nameToLogger.get(name);
        if (logger != null) {
            logger.disable();
        }
    }

    public static synchronized void enableLogger(String name) {
        ILogger logger = (ILogger)nameToLogger.get(name);
        if (logger != null) {
            logger.enable();
        }
    }

    public static synchronized Enumeration getLoggers() {
        Vector loggers = new Vector();
        Enumeration enumeration = nameToLogger.elements();
        while (enumeration.hasMoreElements()) {
            loggers.addElement(enumeration.nextElement());
        }
        return loggers.elements();
    }

    public static synchronized Enumeration getLoggerNames() {
        Vector names = new Vector();
        Enumeration enumeration = nameToLogger.keys();
        while (enumeration.hasMoreElements()) {
            names.addElement(enumeration.nextElement());
        }
        return names.elements();
    }

    private static void setExplicitLogging(String category, boolean flag) {
        explicitLogging.put(category, new Boolean(flag));
    }

    public static Hashtable getExplicitLogging() {
        return explicitLogging;
    }

    public static synchronized void startLogging(long code) {
        Log.startLogging(Log.getCategory(code));
    }

    public static synchronized void startLogging(String category) {
        Log.setExplicitLogging(category, true);
        Enumeration enumeration = nameToLogger.elements();
        while (enumeration.hasMoreElements()) {
            ((ILogger)enumeration.nextElement()).startLogging(category);
        }
    }

    public static synchronized void stopLogging(long code) {
        Log.stopLogging(Log.getCategory(code));
    }

    public static synchronized void stopLogging(String category) {
        Log.setExplicitLogging(category, false);
        Enumeration enumeration = nameToLogger.elements();
        while (enumeration.hasMoreElements()) {
            ((ILogger)enumeration.nextElement()).stopLogging(category);
        }
    }

    public static Enumeration getCategories() {
        return stringToCode.keys();
    }

    public static void log(Object event) {
        Log.log(ILoggingConstants.COMMENT_EVENT, event);
    }

    public static synchronized void log(String category, Throwable throwable) {
        Log.log(Log.getCode(category), throwable);
    }

    public static synchronized void log(long code, Throwable throwable) {
        Log.log(code, null, throwable);
    }

    public static synchronized void log(long code, String message, Throwable throwable) {
        if ((masks & code) == 0L) {
            return;
        }
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        message = message != null ? message + "\n" + writer.toString() : writer.toString();
        Log.log(code, (Object)message);
    }

    public static synchronized void log(String category, Object event) {
        long code = Log.getCode(category);
        if ((masks & code) != 0L) {
            Log.log(code, category, event);
        }
    }

    public static synchronized void log(long code, Object event) {
        if ((masks & code) != 0L) {
            Log.log(code, Log.getCategory(code), event);
        }
    }

    private static synchronized void log(long code, String category, Object event) {
        Date timestamp = new Date();
        Enumeration enumeration = nameToLogger.elements();
        while (enumeration.hasMoreElements()) {
            ILogger logger = (ILogger)enumeration.nextElement();
            if ((logger.getMask() & code) == 0L) continue;
            logger.event(category, event, timestamp);
        }
    }

    static {
        explicitLogging = new Hashtable();
        Log.initLoggers();
    }
}

