/*
 * Decompiled with CFR 0.152.
 */
package electric.util.log;

import electric.util.log.Log;
import electric.util.log.Logger;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class WriterLogger
extends Logger {
    private static final String DEFAULT_FORMAT = "MMM:dd:yyyy hh:mm:ss";
    public static final String EOL = System.getProperty("line.separator");
    private Writer writer;
    private SimpleDateFormat dateFormatter;
    private boolean logThreadName;

    public WriterLogger() {
        this(new OutputStreamWriter(System.out));
    }

    public WriterLogger(Writer writer) {
        this(writer, 0L);
    }

    public WriterLogger(long mask) {
        this(new OutputStreamWriter(System.out), mask);
    }

    public WriterLogger(Writer writer, long mask) {
        super(mask);
        this.logThreadName = false;
        this.writer = writer;
    }

    public WriterLogger(boolean logDate, String dateFormat, boolean logThreadName, boolean logToFile, String fileName, boolean append) {
        block4: {
            this();
            this.logThreadName(logThreadName);
            if (logToFile) {
                try {
                    this.setWriter(new FileWriter(fileName, append));
                }
                catch (IOException exception) {
                    if (!Log.isLogging("ERROR")) break block4;
                    Log.log("ERROR", (Object)("unable to redirect logging to a file " + exception.toString()));
                }
            }
        }
        if (logDate) {
            this.setLogDateTimeFormat(dateFormat);
        }
    }

    public void logDateTime(boolean logDateTime) {
        if (logDateTime) {
            this.setLogDateTimeFormat(DEFAULT_FORMAT);
        } else {
            this.dateFormatter = null;
        }
    }

    public void setLogDateTimeFormat(String format) {
        if (format == null) {
            format = DEFAULT_FORMAT;
        }
        this.dateFormatter = new SimpleDateFormat(format);
    }

    public void logThreadName(boolean logThreadName) {
        this.logThreadName = logThreadName;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void event(String category, Object event, Date timestamp) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append('[').append(category);
            if (this.logThreadName) {
                buffer.append(", ").append(Thread.currentThread().getName());
            }
            if (this.dateFormatter != null) {
                buffer.append(", ").append(this.dateFormatter.format(timestamp));
            }
            buffer.append("] ");
            buffer.append(event).append(EOL);
            this.writer.write(buffer.toString());
            this.writer.flush();
        }
        catch (IOException exception) {
            System.out.println("WriterLogger error: " + exception);
        }
    }
}

