/*
 * Decompiled with CFR 0.152.
 */
package electric.util.path;

import electric.util.Context;
import electric.util.classpath.ClassPath;
import electric.util.path.PathUtil;
import electric.util.product.IProductConfigConstants;
import java.io.File;

public class Paths
implements IProductConfigConstants {
    private static String GLUE_HOME_PROPERTY = "glue.home";
    private static String appPath;
    private static String glueHome;
    private static final String DEFAULT_GLUE_HOME;
    private static final String[] JARS_WITH_CONFIG;

    public static synchronized String getGlueHome() {
        block12: {
            String filePath;
            if (glueHome != null) {
                return glueHome;
            }
            glueHome = Context.getSystemProperty(GLUE_HOME_PROPERTY);
            if (glueHome == null) {
                glueHome = (String)Context.application().getProperty(GLUE_HOME_PROPERTY);
            }
            if (glueHome == null) {
                int i = 0;
                while (i < JARS_WITH_CONFIG.length) {
                    filePath = ClassPath.getJarPath(JARS_WITH_CONFIG[i]);
                    if (filePath != null) {
                        if ((filePath = filePath.substring(0, filePath.length() - JARS_WITH_CONFIG[i].length())).length() == 0) {
                            glueHome = "." + File.separator;
                            break;
                        }
                        if (!filePath.endsWith("lib/") && !filePath.endsWith("lib\\")) break;
                        glueHome = filePath.substring(0, filePath.length() - 4);
                        break;
                    }
                    ++i;
                }
            }
            if (glueHome == null) {
                glueHome = DEFAULT_GLUE_HOME;
            }
            try {
                filePath = glueHome;
                if (!filePath.endsWith(File.separator)) {
                    filePath = filePath + File.separator;
                }
                if (!new File(filePath = filePath + "app-template" + File.separator + "WEB-INF" + File.separator + "glue-config.xml").exists()) {
                    glueHome = DEFAULT_GLUE_HOME;
                }
            }
            catch (Exception exception) {
                if (glueHome != null) break block12;
                glueHome = DEFAULT_GLUE_HOME;
            }
        }
        if (!glueHome.endsWith(File.separator)) {
            glueHome = glueHome + File.separator;
        }
        return glueHome;
    }

    public static String getWebInfPath() {
        if (appPath == null) {
            appPath = Paths.getGlueHome() + "apps" + File.separator + "simple" + File.separator;
        } else if (!(appPath = PathUtil.normalizeSlashes(appPath)).endsWith(File.separator)) {
            appPath = appPath + File.separator;
        }
        return appPath + "WEB-INF" + File.separator;
    }

    public static String getAppPath() {
        return appPath;
    }

    public static void setAppPath(String appPath) {
        Paths.appPath = PathUtil.normalizeSlashes(appPath);
    }

    public static String normalizePath(String filename) {
        if (!new File(filename = PathUtil.normalizeSlashes(filename)).exists()) {
            if (filename.startsWith(File.separator)) {
                filename = filename.substring(1);
            }
            filename = Paths.getWebInfPath() + filename;
        }
        return filename;
    }

    static {
        DEFAULT_GLUE_HOME = File.separator + "glue" + File.separator;
        JARS_WITH_CONFIG = new String[]{"glue.jar", "glue-all.jar"};
    }
}

