/*
 * Decompiled with CFR 0.152.
 */
package electric.util.product;

import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.context.ContextUtil;
import electric.util.license.License;
import electric.util.license.LicensingException;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.path.PathUtil;
import electric.util.path.Paths;
import electric.util.product.IProductConfig;
import electric.util.product.IProductConfigConstants;
import electric.util.resourceloader.ResourceLoaders;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import java.io.File;
import java.io.IOException;

public class Product
implements ILoggingConstants,
IProductConfigConstants {
    private static String[] PRODUCTS_LICENSE_PREFIXES = new String[]{"webMethods", "exml"};
    private static String[] PRODUCTS_CONFIG_PREFIXES = new String[]{"glue", "exml"};
    private static boolean started = false;
    private static boolean startedAsServer = false;
    private static Element configElement;
    private static IProductConfig productConfig;
    private static IProductConfig[] plugins;
    private static Object webApplication;

    public static void addPlugin(IProductConfig plugin) throws Throwable {
        plugins = (IProductConfig[])ArrayUtil.addElement(plugins, plugin);
        if (started) {
            if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)plugin.getProductInfo().getDescription());
            }
            License.verifyLicense(plugin);
            plugin.executeLicenseConstraints();
            plugin.configure(configElement);
            if (startedAsServer) {
                plugin.configureAsServer(configElement, webApplication);
            }
        }
    }

    public static void removePlugin(IProductConfig plugin) {
        plugins = (IProductConfig[])ArrayUtil.removeElement(plugins, plugin);
    }

    public static void startup() {
        Product.startup(null);
    }

    public static void startup(String appPath) {
        Product.startup(appPath, null);
    }

    private static synchronized void startup(String appPath, Element config) {
        if (started) {
            return;
        }
        started = true;
        Paths.setAppPath(appPath);
        try {
            configElement = config != null ? config : Product.getConfig(appPath);
            Product.loadAppContext(configElement);
            productConfig = License.getProductConfig(PRODUCTS_LICENSE_PREFIXES);
            License.verifyLicense(productConfig);
            productConfig.executeLicenseConstraints();
            productConfig.configure(configElement);
            if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)productConfig.getProductInfo().getDescription());
            }
            int i = 0;
            while (i < plugins.length) {
                if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
                    Log.log(ILoggingConstants.STARTUP_EVENT, (Object)plugins[i].getProductInfo().getDescription());
                }
                License.verifyLicense(plugins[i]);
                plugins[i].executeLicenseConstraints();
                plugins[i].configure(configElement);
                ++i;
            }
        }
        catch (LicensingException exception) {
            Log.startLogging(ILoggingConstants.STARTUP_EVENT);
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)exception.getMessage());
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)"place a valid license xml file in class path or contact TME sales to arrange a new license");
            throw exception;
        }
        catch (Throwable throwable) {
            Log.startLogging(ILoggingConstants.STARTUP_EVENT);
            Log.log(ILoggingConstants.STARTUP_EVENT, "exception while starting up platform", throwable);
            throw new RuntimeException(throwable.toString());
        }
    }

    public static void startupAsServer() {
        Product.startupAsServer(null, null, null);
    }

    public static synchronized void startupAsServer(String appPath, Element config, Object webApplication) {
        if (startedAsServer) {
            return;
        }
        startedAsServer = true;
        Product.startup(appPath, config);
        Product.webApplication = webApplication;
        if (config == null) {
            config = configElement;
        }
        try {
            productConfig.configureAsServer(config, webApplication);
            int i = 0;
            while (i < plugins.length) {
                plugins[i].configureAsServer(config, webApplication);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Log.startLogging(ILoggingConstants.STARTUP_EVENT);
            Log.log(ILoggingConstants.STARTUP_EVENT, "exception while starting up platform as server", throwable);
            throw new RuntimeException(throwable.toString());
        }
    }

    public static boolean isStarted() {
        return started;
    }

    public static IProductConfig getProductConfig() {
        if (!Product.isStarted()) {
            Product.startup();
        }
        return productConfig;
    }

    public static String getShortDescription() {
        return productConfig.getProductInfo().getShortDescription();
    }

    public static Element getConfig(String appPath) throws IOException {
        try {
            int i = 0;
            while (i < PRODUCTS_CONFIG_PREFIXES.length) {
                try {
                    return Product.getConfig(PRODUCTS_CONFIG_PREFIXES[i], appPath);
                }
                catch (IOException exception) {
                    ++i;
                }
            }
        }
        catch (ParseException exception) {
            Log.startLogging(ILoggingConstants.STARTUP_EVENT);
            Log.log(ILoggingConstants.STARTUP_EVENT, "syntax error in config file", exception);
        }
        throw new IOException("unable to load config file");
    }

    public static Element getConfig(String product, String appPath) throws IOException, ParseException {
        String configPath = Context.getSystemProperty(product + ".config");
        if (configPath != null) {
            return Product.readConfig(configPath);
        }
        try {
            if (appPath == null) {
                return Product.readConfig(product + "-config.xml");
            }
            if (!(appPath = PathUtil.normalizeSlashes(appPath)).endsWith(File.separator)) {
                appPath = appPath + File.separator;
            }
            return Product.readConfig(appPath + "WEB-INF" + File.separator + product + "-config.xml");
        }
        catch (IOException exception) {
            return Product.readConfig(product + "-default-config.xml");
        }
    }

    private static Element readConfig(String path) throws IOException, ParseException {
        byte[] bytes = ResourceLoaders.loadResource(path);
        return new Document(bytes, 1).getRoot();
    }

    public static void loadAppContext(Element config) {
        Element appContextElement = config.getElement("applicationContext");
        if (appContextElement == null) {
            return;
        }
        ContextUtil.populate(Context.application(), appContextElement);
    }

    public static Element getConfig() {
        return configElement;
    }

    static {
        plugins = new IProductConfig[0];
    }
}

