/*
 * Decompiled with CFR 0.152.
 */
package electric.util.reflect;

import electric.util.array.ArrayUtil;
import electric.util.string.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class BeanField {
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String IS = "is";
    public String name;
    public Method get;
    public Method set;
    public Class type;

    public BeanField(String name, Method get, Method set) {
        this.name = name;
        this.get = get;
        this.set = set;
        this.type = get.getReturnType();
    }

    public String toString() {
        return "BeanField( " + this.name + ", " + this.get + ", " + this.set + " )";
    }

    public static BeanField[] getBeanFields(Class type) {
        Method[] methods = type.getDeclaredMethods();
        BeanField[] beanFields = new BeanField[]{};
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            String name = method.getName();
            int index = BeanField.getIndex(name);
            if (method.getParameterTypes().length == 0 && BeanField.isGetter(name) && !Modifier.isStatic(method.getModifiers())) {
                try {
                    String setName = SET + name.substring(index);
                    String fieldName = Character.toLowerCase(name.charAt(index)) + name.substring(index + 1);
                    Method set = type.getMethod(setName, method.getReturnType());
                    BeanField beanField = new BeanField(fieldName, method, set);
                    beanFields = (BeanField[])ArrayUtil.addElement(beanFields, beanField);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return beanFields;
    }

    private static boolean isGetter(String name) {
        if (name.startsWith(GET)) {
            return name.length() > 3 && Character.isUpperCase(name.charAt(3));
        }
        if (name.startsWith(IS)) {
            return name.length() > 2 && Character.isUpperCase(name.charAt(2));
        }
        return false;
    }

    public static int getIndex(String name) {
        if (name.startsWith(GET)) {
            return 3;
        }
        if (name.startsWith(IS)) {
            return 2;
        }
        return -1;
    }

    public static BeanField getBeanField(Class type, String name) {
        String capitalized = Strings.getCapitalized(name);
        try {
            Method get = null;
            try {
                get = type.getMethod(GET + capitalized, null);
            }
            catch (NoSuchMethodException error) {
                get = type.getMethod(IS + capitalized, null);
            }
            Method set = type.getMethod(SET + capitalized, get.getReturnType());
            return new BeanField(name, get, set);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object get(Object object) throws InvocationTargetException, IllegalAccessException {
        return this.get.invoke(object, null);
    }

    public void set(Object object, Object value) throws InvocationTargetException, IllegalAccessException {
        this.set.invoke(object, value);
    }
}

