/*
 * Decompiled with CFR 0.152.
 */
package electric.util.reflect;

import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.reflect.MethodLookup;
import electric.util.reflect.Wrappers;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

public final class Reflect {
    private static final Class[] STRING_ARG = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Reflect.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Void;

    public static String asString(Class type) {
        return type.isArray() ? Reflect.asString(type.getComponentType()) + "[]" : type.getName();
    }

    public static Class getClass(String className) throws ClassNotFoundException {
        int dim = 0;
        while (className.endsWith("[]")) {
            className = className.substring(0, className.length() - 2);
            ++dim;
        }
        Class<?> type = Wrappers.getPrimitiveClass(className);
        if (type == null) {
            type = ClassLoaders.loadClass(className);
        }
        return dim == 0 ? type : Array.newInstance(type, new int[dim]).getClass();
    }

    public static Object valueOf(String string, Class type) throws IOException {
        try {
            if (type == Integer.TYPE) {
                return Integer.valueOf(string);
            }
            if (type == (class$java$lang$String == null ? (class$java$lang$String = Reflect.class$("java.lang.String")) : class$java$lang$String)) {
                return string;
            }
            if (type == Float.TYPE) {
                return Float.valueOf(string);
            }
            if (type == Double.TYPE) {
                return Double.valueOf(string);
            }
            if (type == Byte.TYPE) {
                return Byte.valueOf(string);
            }
            if (type == Short.TYPE) {
                return Short.valueOf(string);
            }
            if (type == Boolean.TYPE) {
                return Boolean.valueOf(string);
            }
            if (type == Long.TYPE) {
                return Long.valueOf(string);
            }
            if (type == Character.TYPE || type == (class$java$lang$Character == null ? (class$java$lang$Character = Reflect.class$("java.lang.Character")) : class$java$lang$Character)) {
                return new Character(string.charAt(0));
            }
            if (type == (class$java$lang$Object == null ? (class$java$lang$Object = Reflect.class$("java.lang.Object")) : class$java$lang$Object)) {
                return string;
            }
            Constructor ctor = type.getConstructor(STRING_ARG);
            return ctor.newInstance(string);
        }
        catch (InvocationTargetException exception) {
            throw new IOException(exception.getTargetException().toString());
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public static Object invoke(Object object, String methodName, String[] methodArgs) throws Throwable {
        Class<?> type = object instanceof Class ? (Class<?>)object : object.getClass();
        Method method = MethodLookup.getMethod(type, methodName, methodArgs.length);
        Object[] args = new Object[methodArgs.length];
        int i = 0;
        while (i < args.length) {
            args[i] = Reflect.valueOf(methodArgs[i], method.getParameterTypes()[i]);
            ++i;
        }
        try {
            return method.invoke(object, args);
        }
        catch (InvocationTargetException exception) {
            throw exception.getTargetException();
        }
    }

    public static boolean matches(Method x, Method y) {
        Class<?>[] yParameters;
        if (!x.getName().equals(y.getName())) {
            return false;
        }
        Class<?>[] xParameters = x.getParameterTypes();
        if (xParameters.length != (yParameters = y.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < xParameters.length) {
            if (xParameters[i] != yParameters[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean matches(Class[] formals, Class[] actuals, boolean exact) {
        if (actuals.length != formals.length) {
            return false;
        }
        if (exact) {
            int i = 0;
            while (i < actuals.length) {
                if (!Reflect.matchesExactly(formals[i], actuals[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < actuals.length) {
                if (!Reflect.matchesLoosely(formals[i], actuals[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean matchesExactly(Class formal, Class actual) {
        if (formal == null) {
            Reflect.throwNoFormalArgumentException(actual);
        }
        if (actual == (class$java$lang$Void == null ? (class$java$lang$Void = Reflect.class$("java.lang.Void")) : class$java$lang$Void)) {
            return true;
        }
        return actual == null ? !formal.isPrimitive() : formal.isAssignableFrom(actual);
    }

    public static boolean matchesLoosely(Class formal, Class actual) {
        if (formal == null) {
            Reflect.throwNoFormalArgumentException(actual);
        }
        if (actual == (class$java$lang$Void == null ? (class$java$lang$Void = Reflect.class$("java.lang.Void")) : class$java$lang$Void)) {
            return true;
        }
        if (actual == null) {
            if (!formal.isPrimitive()) {
                return true;
            }
        } else {
            if (formal.isAssignableFrom(actual)) {
                return true;
            }
            if (formal.isPrimitive() && !actual.isPrimitive() && actual.isAssignableFrom(Wrappers.getWrapperClass(formal))) {
                return true;
            }
            if (actual.isPrimitive() && !formal.isPrimitive() && formal.isAssignableFrom(Wrappers.getWrapperClass(actual))) {
                return true;
            }
        }
        return false;
    }

    private static void throwNoFormalArgumentException(Class actual) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Could not find method for proxy invocation.");
        if (actual != null) {
            buffer.append("  Class " + actual + " was passed in.");
        }
        buffer.append("  Please check that you are reading in map files.");
        throw new IllegalStateException(buffer.toString());
    }

    public static boolean dominates(Class[] argClasses1, Class[] argClasses2) {
        int i = 0;
        while (i < argClasses1.length) {
            if (!argClasses2[i].isAssignableFrom(argClasses1[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Class[] getClasses(Object[] args) {
        Class[] classes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            classes[i] = args[i] == null ? null : args[i].getClass();
            ++i;
        }
        return classes;
    }

    public static Class[] getInterfaces(Class type) {
        Vector<Class> vector = new Vector<Class>();
        if (type.isInterface()) {
            vector.addElement(type);
        }
        Reflect.addInterfaces(vector, type);
        Object[] interfaces = new Class[vector.size()];
        vector.copyInto(interfaces);
        return interfaces;
    }

    public static Class[] filter(Class[] types, Class[] interfaces) {
        Vector<Class> vector = new Vector<Class>();
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < interfaces.length) {
                if (interfaces[j].isAssignableFrom(types[i])) {
                    vector.addElement(types[i]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        Object[] results = new Class[vector.size()];
        vector.copyInto(results);
        return results;
    }

    public static boolean isImplementedBy(Method method, Class[] types) {
        String name = method.getName();
        Class<?>[] parameters = method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            try {
                types[i].getMethod(name, parameters);
                return true;
            }
            catch (Exception exception) {
                ++i;
            }
        }
        return false;
    }

    public static Method[] getMethodsImplementedBy(Method[] methods, Class[] types) {
        Vector<Method> vector = new Vector<Method>();
        int i = 0;
        while (i < methods.length) {
            if (Reflect.isImplementedBy(methods[i], types)) {
                vector.addElement(methods[i]);
            }
            ++i;
        }
        Object[] results = new Method[vector.size()];
        vector.copyInto(results);
        return results;
    }

    public static Method[] getMethodsNotImplementedBy(Method[] methods, Class[] types) {
        Vector<Method> vector = new Vector<Method>();
        int i = 0;
        while (i < methods.length) {
            if (!Reflect.isImplementedBy(methods[i], types)) {
                vector.addElement(methods[i]);
            }
            ++i;
        }
        Object[] results = new Method[vector.size()];
        vector.copyInto(results);
        return results;
    }

    public static Method[] getInterfaceMethods(Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("argument must be an interface - " + interfaceClass.getName());
        }
        Method[] methods = interfaceClass.getDeclaredMethods();
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        Method[] finalSet = new Method[methods.length];
        System.arraycopy(methods, 0, finalSet, 0, methods.length);
        int i = 0;
        while (i < interfaces.length) {
            Method[] interfaceMethods = Reflect.getInterfaceMethods(interfaces[i]);
            int k = 0;
            while (k < interfaceMethods.length) {
                block5: {
                    String methodName = interfaceMethods[k].getName();
                    Class[] args = interfaceMethods[k].getParameterTypes();
                    int j = 0;
                    while (j < methods.length) {
                        if (!methodName.equals(methods[j].getName()) || !Reflect.matches(args, methods[j].getParameterTypes(), true)) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    finalSet = (Method[])ArrayUtil.addElement(finalSet, interfaceMethods[k]);
                }
                ++k;
            }
            ++i;
        }
        return finalSet;
    }

    public static Method getInterfaceMethod(Method method) {
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class[] interfaces = Reflect.getInterfaces(method.getDeclaringClass());
        int i = 0;
        while (i < interfaces.length) {
            try {
                return interfaces[i].getMethod(name, parameterTypes);
            }
            catch (Exception exception) {
                ++i;
            }
        }
        return null;
    }

    private static void addInterfaces(Vector vector, Class type) {
        if (type.getSuperclass() != null && !type.getSuperclass().equals(class$java$lang$Object == null ? (class$java$lang$Object = Reflect.class$("java.lang.Object")) : class$java$lang$Object)) {
            Reflect.addInterfaces(vector, type.getSuperclass());
        }
        Class<?>[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            vector.addElement(interfaces[i]);
            Reflect.addInterfaces(vector, interfaces[i]);
            ++i;
        }
    }

    public static Field getDeclaredField(Class type, String name) throws NoSuchFieldException {
        try {
            return type.getDeclaredField(name);
        }
        catch (NoSuchFieldException exception) {
            if (type.getSuperclass() != null) {
                return Reflect.getDeclaredField(type.getSuperclass(), name);
            }
            throw exception;
        }
    }

    public static boolean isAssignableFrom(String className, Class assigneeClass) {
        try {
            Class assignableClass = ClassLoaders.loadClass(className, ClassLoaders.getServletClassLoader());
            return assignableClass.isAssignableFrom(assigneeClass);
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException("unable to find class " + className);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

