/*
 * Decompiled with CFR 0.152.
 */
package electric.util.reflect;

import electric.util.array.ArrayUtil;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Wrappers {
    private static final Hashtable wrapperToPrimitive = new Hashtable();
    private static final Hashtable primitiveToWrapper = new Hashtable();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;

    private static void initWrappers() {
        Wrappers.addWrapper(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = Wrappers.class$("java.lang.Integer")) : class$java$lang$Integer);
        Wrappers.addWrapper(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = Wrappers.class$("java.lang.Byte")) : class$java$lang$Byte);
        Wrappers.addWrapper(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = Wrappers.class$("java.lang.Short")) : class$java$lang$Short);
        Wrappers.addWrapper(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = Wrappers.class$("java.lang.Long")) : class$java$lang$Long);
        Wrappers.addWrapper(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = Wrappers.class$("java.lang.Float")) : class$java$lang$Float);
        Wrappers.addWrapper(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = Wrappers.class$("java.lang.Double")) : class$java$lang$Double);
        Wrappers.addWrapper(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Wrappers.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        Wrappers.addWrapper(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = Wrappers.class$("java.lang.Character")) : class$java$lang$Character);
    }

    private static void addWrapper(Class primitive, Class wrapper) {
        primitiveToWrapper.put(primitive, wrapper);
        wrapperToPrimitive.put(wrapper, primitive);
    }

    public static Class getWrapperClass(Class primitive) {
        return (Class)primitiveToWrapper.get(primitive);
    }

    public static Class getPrimitiveClass(Class wrapper) {
        return (Class)wrapperToPrimitive.get(wrapper);
    }

    public static Class getPrimitiveClass(String className) {
        Enumeration enumeration = primitiveToWrapper.keys();
        while (enumeration.hasMoreElements()) {
            Class javaClass = (Class)enumeration.nextElement();
            if (!javaClass.getName().equalsIgnoreCase(className)) continue;
            return javaClass;
        }
        return null;
    }

    public static Object convertToWrapperArray(Object primitiveArray) {
        int[] dimensions = new int[]{};
        Class<?> arrayClass = primitiveArray.getClass();
        while (arrayClass.isArray()) {
            dimensions = ArrayUtil.addElement(dimensions, 0);
            arrayClass = arrayClass.getComponentType();
        }
        Object newArray = Array.newInstance(Wrappers.getWrapperClass(arrayClass), dimensions);
        return Wrappers.copyArray(primitiveArray, newArray);
    }

    public static Object convertToPrimitiveArray(Object wrapperArray) {
        int[] dimensions = new int[]{};
        Class<?> arrayClass = wrapperArray.getClass();
        while (arrayClass.isArray()) {
            dimensions = ArrayUtil.addElement(dimensions, 0);
            arrayClass = arrayClass.getComponentType();
        }
        Object newArray = Array.newInstance(Wrappers.getPrimitiveClass(arrayClass), dimensions);
        return Wrappers.copyArray(wrapperArray, newArray);
    }

    private static Object copyArray(Object srcArray, Object destArray) {
        int length = Array.getLength(srcArray);
        if (length != Array.getLength(destArray)) {
            destArray = Array.newInstance(destArray.getClass().getComponentType(), length);
        }
        int i = 0;
        while (i < length) {
            Object member = Array.get(srcArray, i);
            if (member.getClass().isArray()) {
                Object destMember = Array.get(destArray, i);
                if (destMember == null) {
                    destMember = Array.newInstance(destArray.getClass().getComponentType().getComponentType(), Array.getLength(member));
                }
                member = Wrappers.copyArray(member, destMember);
            }
            Array.set(destArray, i, member);
            ++i;
        }
        return destArray;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Wrappers.initWrappers();
    }
}

