/*
 * Decompiled with CFR 0.152.
 */
package electric.util.thread;

import electric.util.array.ArrayUtil;
import electric.util.thread.Task;
import electric.util.thread.ThreadPool;

public class Tasks
extends Thread {
    private static Tasks shared;
    private ThreadPool threadPool;
    private Task[] tasks = new Task[0];
    private boolean shutdown;

    public Tasks() {
        this(ThreadPool.getShared());
    }

    public Tasks(ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.setName("Tasks:" + this.getName());
    }

    public Task runAt(Runnable runnable, long time, String name, long period, boolean newThread) {
        if (time == 0L) {
            time = System.currentTimeMillis();
        }
        Task task = new Task(runnable, name, time, -1L, period, newThread);
        this.add(task);
        return task;
    }

    public Task runAt(Runnable runnable, long time) {
        return this.runAt(runnable, time, "unnamed", 0L, false);
    }

    public Task run(Runnable runnable) {
        return this.runAt(runnable, 0L, "unnamed", 0L, false);
    }

    public Task runAfter(Runnable runnable, long time, String name, long period, boolean newThread) {
        Task task = new Task(runnable, name, time + System.currentTimeMillis(), time, period, newThread);
        this.add(task);
        return task;
    }

    public Task runAfter(Runnable runnable, long time) {
        return this.runAfter(runnable, time, "unnamed", 0L, false);
    }

    public synchronized void add(Task task) {
        task.tasks = this;
        if (this.tasks.length == 0) {
            this.tasks = new Task[]{task};
            this.notify();
        } else if (task.at < this.tasks[0].at) {
            this.tasks = (Task[])ArrayUtil.insertElement(this.tasks, task);
            this.notify();
        } else if (task.at >= this.tasks[this.tasks.length - 1].at) {
            this.tasks = (Task[])ArrayUtil.addElement(this.tasks, task);
        } else {
            int i = 1;
            while (i < this.tasks.length) {
                if (task.at < this.tasks[i].at) {
                    this.tasks = (Task[])ArrayUtil.insertElementAt(this.tasks, task, i);
                    break;
                }
                ++i;
            }
        }
    }

    public synchronized boolean remove(Task task) {
        int index = ArrayUtil.indexOf(task, this.tasks);
        if (index == -1) {
            return false;
        }
        this.tasks = (Task[])ArrayUtil.removeElementAt(this.tasks, index);
        if (index == 0) {
            this.notify();
        }
        return true;
    }

    public void run() {
        Task task;
        while ((task = this.getNextTask()) != null) {
            if (task.newThread) {
                this.threadPool.run(task.runnable);
            } else {
                try {
                    task.runnable.run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (task.period <= 0L) continue;
            task.at = System.currentTimeMillis() + task.period;
            this.add(task);
        }
        return;
    }

    private synchronized Task getNextTask() {
        while (!this.shutdown) {
            if (this.tasks.length == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException exception) {}
                continue;
            }
            Task task = this.tasks[0];
            long timeLeft = task.at - System.currentTimeMillis();
            if (timeLeft > 0L) {
                try {
                    this.wait(timeLeft);
                }
                catch (InterruptedException exception) {}
                continue;
            }
            this.remove(task);
            return task;
        }
        return null;
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.notify();
    }

    public static synchronized Tasks getShared() {
        if (shared != null) {
            return shared;
        }
        shared = new Tasks();
        shared.setDaemon(true);
        shared.start();
        return shared;
    }
}

