/*
 * Decompiled with CFR 0.152.
 */
package electric.webserver;

import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.webserver.WebServer;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class WebServers {
    private static final Hashtable portToWebServer = new Hashtable();

    public static void addWebServer(int port, WebServer webServer) {
        portToWebServer.put(new Integer(port), webServer);
    }

    public static WebServer getWebServer(int port) {
        return (WebServer)portToWebServer.get(new Integer(port));
    }

    public static void removeWebServer(int port) {
        portToWebServer.remove(new Integer(port));
    }

    public static WebServer[] getWebServers() {
        WebServer[] webServers = new WebServer[]{};
        Enumeration enumeration = portToWebServer.elements();
        while (enumeration.hasMoreElements()) {
            webServers = (WebServer[])ArrayUtil.addElement(webServers, enumeration.nextElement());
        }
        return webServers;
    }

    public static WebServer startWebServer(String url) throws IOException {
        return WebServers.startWebServer(new XURL(url));
    }

    public static WebServer startWebServer(XURL xurl) throws IOException {
        WebServer webServer = WebServers.getWebServer((xurl = new XURL(xurl.getProtocol(), xurl.getHost(), xurl.getPort(), null, null)).getPort());
        if (webServer == null) {
            webServer = new WebServer(xurl.toString());
            webServer.startup();
        } else if (!webServer.getXURL().getProtocol().equals(xurl.getProtocol())) {
            throw new IOException("server " + webServer.getXURL() + " already running");
        }
        return webServer;
    }

    public static void shutdownAllWebServers() {
        Enumeration enumeration = portToWebServer.elements();
        while (enumeration.hasMoreElements()) {
            try {
                ((WebServer)enumeration.nextElement()).shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        portToWebServer.clear();
    }
}

