/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.util.named.IQNamed;
import electric.util.reflect.IOperation;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.PortType;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.io.Namespaces;
import electric.xml.io.schema.SchemaException;
import java.util.Enumeration;

public class Binding
implements IQNamed,
IWSDLConstants {
    private static IOperation[] NO_OPERATIONS = new IOperation[0];
    protected WSDL wsdl;
    protected String targetNamespace;
    protected String name;
    protected PortType portType;

    public Binding(WSDL wsdl, String targetNamespace, Element root) throws WSDLException, SchemaException {
        this.wsdl = wsdl;
        this.targetNamespace = targetNamespace;
        this.name = root.getAttributeValue("name");
        if (this.name == null) {
            throw new WSDLException("<binding> is missing name attribute");
        }
        String portTypeName = root.getAttributeValue("type");
        if (portTypeName == null) {
            throw new WSDLException("<binding> is missing type attribute");
        }
        this.portType = wsdl.getPortType(root.getQName(portTypeName));
    }

    public Binding(WSDL wsdl, String namespace, String name) {
        this.wsdl = wsdl;
        this.targetNamespace = namespace;
        this.name = name;
    }

    public String toString() {
        return "Binding( " + this.targetNamespace + ":" + this.name + " )";
    }

    public WSDL getWSDL() {
        return this.wsdl;
    }

    public Namespaces getNamespaces() {
        return this.wsdl.getNamespaces();
    }

    public String getNamespace() {
        return this.targetNamespace;
    }

    public String getName() {
        return this.name;
    }

    public PortType getPortType() {
        return this.portType;
    }

    public IOperation[] getOperations() {
        return NO_OPERATIONS;
    }

    public Enumeration getTypes() throws SchemaException {
        return this.portType.getTypes();
    }

    public Element writeWSDL(Element definitions) {
        return this.writeWSDLBinding(definitions);
    }

    protected Element writeWSDLBinding(Element definitions) {
        String wsdlPrefix = definitions.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element binding = definitions.addElement(wsdlPrefix, "binding");
        binding.setAttribute("name", this.name);
        binding.setAttribute("type", "tns:" + this.portType.getName());
        return binding;
    }
}

