/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl.tools;

import electric.application.web.WebApplication;
import electric.glue.IGLUEContextConstants;
import electric.service.descriptor.MethodDescriptor;
import electric.servlet.webinf.IWebInfConstants;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.command.Commands;
import electric.util.file.FileUtil;
import electric.util.product.Product;
import electric.util.reflect.Reflect;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.generator.WSDLGenerator;
import electric.xml.io.Mappings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;

public class Java2WSDL
implements IWSDLConstants,
IGLUEContextConstants,
IWebInfConstants {
    private static final String[] DEFAULT_PROTOCOLS = new String[]{"soap"};
    private static String[] classNames = new String[0];
    private static String endpoint = null;
    private static String description = null;
    private static String targetNamespace = null;
    private static Context context = new Context();
    private static String dir = "";
    private static String[] protocols = new String[0];
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] args) {
        if (args.length == 0) {
            Java2WSDL.printUsage();
            return;
        }
        try {
            Java2WSDL.processArgs(args);
            Product.startup();
            Java2WSDL.java2wsdl();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Java2WSDL.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: java2wsdl [-Dname=value]* [-h] classname+ [-a appname] [-d dir] [-e url] [-g] [-i path] [-j prefix] [-l] [-n namespace] [-r descr] [-s] [-t] [-x cmdfile]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value = set java system property");
        System.out.println("  classname    = name of java class or interface");
        System.out.println("  -a appname   = read/write map files from appname\\WEB-INF\\maps");
        System.out.println("  -d dir       = output directory");
        System.out.println("  -e url       = endpoint of service");
        System.out.println("  -g           = include GET/POST binding");
        System.out.println("  -h           = print help and exit");
        System.out.println("  -i path      = input path for map files, '.' by default");
        System.out.println("  -j prefix    = namespace prefix");
        System.out.println("  -l           = use document/literal style instead of rpc/encoded");
        System.out.println("  -n namespace = namespace for service");
        System.out.println("  -r descr     = description of service");
        System.out.println("  -s           = include SOAP binding");
        System.out.println("  -t           = targetNamespace");
        System.out.println("  -x cmdfile   = command file to execute");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("java2wsdl examples.publish.Exchange -e http://localhost:8004/glue/exchange");
        System.out.println("  create wsdl for java class examples.publish.Exchange, use specified endpoint");
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                classNames = (String[])ArrayUtil.addElement(classNames, arg);
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'a': {
                        Mappings.clear();
                        String appName = Strings.getString("a", args, ++i);
                        File appDir = new File(appName);
                        if (!appDir.exists()) {
                            appDir = new File(WebApplication.getAppHome(), appName);
                        }
                        if (!appDir.exists()) {
                            throw new IllegalArgumentException("cannot find application directory at " + appDir.getAbsolutePath());
                        }
                        File mapDir = new File(appDir, "WEB-INF" + File.separator + "maps");
                        Mappings.readMappings(mapDir.getAbsolutePath());
                        break;
                    }
                    case 'd': {
                        dir = Strings.getString("d", args, ++i);
                        if (dir.endsWith("/") || dir.endsWith("\\")) break;
                        dir = dir + File.separator;
                        break;
                    }
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'e': {
                        endpoint = Strings.getString("e", args, ++i);
                        break;
                    }
                    case 'g': {
                        protocols = (String[])ArrayUtil.addElement(protocols, "getpost");
                        break;
                    }
                    case 'h': {
                        Java2WSDL.printUsage();
                        System.exit(-1);
                    }
                    case 'i': {
                        String mapPath = Strings.getString("i", args, ++i);
                        Mappings.readMappings(mapPath);
                        break;
                    }
                    case 'j': {
                        String namespacePrefix = Strings.getString("j", args, ++i);
                        Mappings.setNamespacePrefix(namespacePrefix);
                        break;
                    }
                    case 'l': {
                        context.setProperty("style", "document");
                        break;
                    }
                    case 'n': {
                        context.setProperty("namespace", Strings.getString("n", args, ++i));
                        break;
                    }
                    case 'r': {
                        description = Strings.getString("r", args, ++i);
                        break;
                    }
                    case 's': {
                        protocols = (String[])ArrayUtil.addElement(protocols, "soap");
                        break;
                    }
                    case 't': {
                        targetNamespace = Strings.getString("t", args, ++i);
                        break;
                    }
                    case 'x': {
                        String commandFile = Strings.getString("x", args, ++i);
                        Commands.execute(commandFile);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        if (classNames.length == 0) {
            throw new IllegalArgumentException("missing class names");
        }
    }

    private static void java2wsdl() throws IOException, WSDLException, ClassNotFoundException {
        Java2WSDL.java2wsdl(classNames, endpoint, description, targetNamespace, context, dir, protocols);
    }

    public static void java2wsdl(String[] classNames, String endpoint, String description, String targetNamespace, Context context, String dir, String[] protocols) throws IOException, WSDLException, ClassNotFoundException {
        Class[] types = new Class[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            types[i] = ClassLoaders.loadClass(classNames[i]);
            ++i;
        }
        Java2WSDL.java2wsdl(types, endpoint, description, targetNamespace, context, dir, protocols);
    }

    public static void java2wsdl(Class[] types, String endpoint, String description, String targetNamespace, Context context, String dir, String[] protocols) throws IOException, WSDLException {
        XURL[] xURLArray;
        XURL xurl;
        XURL xURL = xurl = endpoint == null ? null : new XURL(endpoint);
        if (xurl != null) {
            XURL[] xURLArray2 = new XURL[1];
            xURLArray = xURLArray2;
            xURLArray2[0] = xurl;
        } else {
            xURLArray = new XURL[]{};
        }
        XURL[] endpoints = xURLArray;
        Class javaClass = null;
        Class[] interfaces = new Class[]{};
        int i = 0;
        while (i < types.length) {
            Class type = types[i];
            if (type.isInterface()) {
                interfaces = (Class[])ArrayUtil.addElement(interfaces, type);
            } else if (javaClass == null) {
                javaClass = type;
            } else {
                throw new IllegalArgumentException("you cannot specify more than one java class");
            }
            ++i;
        }
        if (targetNamespace == null) {
            targetNamespace = javaClass != null ? WSDL.getTargetNamespace(javaClass.getName(), context) : WSDL.getTargetNamespace(interfaces[0].getName(), context);
        }
        WSDL.setProtocols(protocols.length > 0 ? protocols : DEFAULT_PROTOCOLS);
        WSDL wsdl = null;
        if (interfaces.length == 0) {
            Method[] methods = javaClass.getMethods();
            methods = Reflect.getMethodsNotImplementedBy(methods, new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Java2WSDL.class$("java.lang.Object")) : class$java$lang$Object});
            MethodDescriptor[] descriptors = new MethodDescriptor[methods.length];
            int j = 0;
            while (j < methods.length) {
                descriptors[j] = new MethodDescriptor(methods[j]);
                ++j;
            }
            wsdl = WSDLGenerator.getWSDL(endpoints, description, context, descriptors, javaClass);
        } else {
            String name = javaClass != null ? javaClass.getName() : interfaces[0].getName();
            wsdl = WSDLGenerator.getWSDL(endpoints, description, context, javaClass, interfaces);
        }
        String filename = Strings.tail(wsdl.getName(), '.');
        FileUtil.saveFile(dir, filename, wsdl.getDocument().toString(), ".wsdl");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

