/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl.tools;

import electric.application.web.WebApplication;
import electric.glue.IGLUELoggingConstants;
import electric.holder.Holders;
import electric.jaxrpc.JAXHolderType;
import electric.security.Login;
import electric.servlet.webinf.IWebInfConstants;
import electric.soap.rpc.Out;
import electric.soap.rpc.Parameter;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPMessageDecl;
import electric.soap.wsdl.SOAPOperation;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.command.Commands;
import electric.util.file.FileUtil;
import electric.util.jar.Jar;
import electric.util.java.JavaSource;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;
import electric.util.resourceloader.ResourceLoaders;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;
import electric.wsdl.Binding;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Part;
import electric.wsdl.Service;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.loader.WSDLLoader;
import electric.wsdl.parser.WSDLParser;
import electric.wsdl.tools.IFileListener;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import electric.xml.io.Mappings;
import electric.xml.io.Type;
import electric.xml.io.accessors.FieldAccessor;
import electric.xml.io.array.ArrayType;
import electric.xml.io.complex.ComplexContent;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.complex.SimpleContent;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.model.All;
import electric.xml.io.model.Group;
import electric.xml.io.model.IModel;
import electric.xml.io.model.Sequence;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.io.simple.SimpleType;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class WSDL2Java
implements ILoaderConstants,
IWSDLConstants,
IGLUELoggingConstants,
IWebInfConstants {
    private static final String DEFAULT_INTERFACE_PREFIX = "I";
    private static final String DEFAULT_INTERFACE_SUFFIX = "";
    private static final String JAVA_EXTENSION = ".java";
    private String url;
    private String dir = "";
    private String pkg;
    private String mapPath;
    private String mapDir;
    private String namespacePrefix;
    private boolean checkedExceptions;
    private boolean generateAccessors;
    private boolean verbose;
    private boolean generateSkeleton;
    private String interfacePrefix = "I";
    private boolean generateFaults = true;
    private boolean forceExceptionInheritance = false;
    private String interfaceSuffix = "";
    private IFileListener listener;
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPBinding;
    static /* synthetic */ Class class$java$lang$Exception;

    public static void main(String[] args) {
        if (args.length == 0) {
            WSDL2Java.printUsage();
            return;
        }
        try {
            WSDL2Java wsdl2java = WSDL2Java.processArgs(args);
            Product.startup();
            wsdl2java.wsdl2java();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            WSDL2Java.printUsage();
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void printUsage() {
        System.out.println("usage: wsdl2java [-Dname=value]* [-h] url [-a appname] [-c] [-d dir] [-i path] [-j namespace] [-l realm usr passwd] [-o dir/jar] [-p package] [-r] [-s] [-v] [-x cmdfile] [-y prefix]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value        = set java system property");
        System.out.println("  url                 = path of wsdl");
        System.out.println("  -a appname          = read/write map files from appname\\WEB-INF\\maps");
        System.out.println("  -c                  = checked exceptions");
        System.out.println("  -d dir              = output directory for java files, '.' by default");
        System.out.println("  -f                  = turn off processing of wsdl fault declarations");
        System.out.println("  -F                  = be aggressive about forcing faults to inherit from java.lang.Exception");
        System.out.println("  -g                  = generate get/set methods");
        System.out.println("  -h                  = print help and exit");
        System.out.println("  -i path             = input path for map files, '.' by default");
        System.out.println("  -j prefix           = namespace prefix");
        System.out.println("  -l realm usr passwd = login credentials");
        System.out.println("  -o dir/jar          = output location for map files, '.' by default");
        System.out.println("  -p package          = set default package");
        System.out.println("  -r                  = generate JAX-RPC holders, false by default");
        System.out.println("  -s                  = generate server skeleton, false by default");
        System.out.println("  -v                  = verbose");
        System.out.println("  -x cmdfile          = command file to execute");
        System.out.println("  -y prefix           = interface prefix");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("wsdl2java http://services.xmethods.net/soap/urn:xmethods-delayed-quotes.wsdl -p examples.wsdl");
        System.out.println("  create java bindings and map files for service at specified wsdl, place into package examples.wsdl");
    }

    private static WSDL2Java processArgs(String[] args) throws Throwable {
        WSDL2Java wsdl2java = new WSDL2Java();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                wsdl2java.setUrl(arg);
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'a': {
                        String appName = Strings.getString("a", args, ++i);
                        File appDir = new File(appName);
                        if (!appDir.exists()) {
                            appDir = new File(WebApplication.getAppHome(), appName);
                        }
                        if (!appDir.exists()) {
                            throw new IllegalArgumentException("cannot find application directory at " + appDir.getAbsolutePath());
                        }
                        wsdl2java.setMapPath(new File(appDir, "WEB-INF" + File.separator + "maps").getAbsolutePath());
                        if (wsdl2java.getMapDir() != null) break;
                        wsdl2java.setMapDir(wsdl2java.getMapPath());
                        break;
                    }
                    case 'c': {
                        wsdl2java.setCheckedExceptions(true);
                        break;
                    }
                    case 'd': {
                        String dir = Strings.getString("d", args, ++i);
                        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
                            dir = dir + File.separator;
                        }
                        wsdl2java.setDir(dir);
                        break;
                    }
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'f': {
                        wsdl2java.setGenerateFaults(false);
                        break;
                    }
                    case 'F': {
                        wsdl2java.setForceExceptionInheritance(true);
                        break;
                    }
                    case 'g': {
                        wsdl2java.setGenerateAccessors(true);
                        break;
                    }
                    case 'h': {
                        WSDL2Java.printUsage();
                        System.exit(-1);
                    }
                    case 'i': {
                        wsdl2java.setMapPath(Strings.getString("i", args, ++i));
                        break;
                    }
                    case 'j': {
                        wsdl2java.setNamespacePrefix(Strings.getString("j", args, ++i));
                        break;
                    }
                    case 'l': {
                        String realm = Strings.getString("l", args, ++i);
                        String user = Strings.getString("l", args, ++i);
                        String password = Strings.getString("l", args, ++i);
                        Login.setCredentials(realm, user, password);
                        break;
                    }
                    case 'o': {
                        String outputMapDir = Strings.getString("o", args, ++i);
                        if (wsdl2java.getMapDir() != null) break;
                        wsdl2java.setMapDir(outputMapDir);
                        break;
                    }
                    case 'p': {
                        wsdl2java.setPkg(Strings.getString("p", args, ++i));
                        break;
                    }
                    case 'r': {
                        Holders.setHolderType(new JAXHolderType());
                        break;
                    }
                    case 's': {
                        wsdl2java.setGenerateSkeleton(true);
                        break;
                    }
                    case 'v': {
                        wsdl2java.setVerbose(true);
                        break;
                    }
                    case 'x': {
                        String commandFile = Strings.getString("x", args, ++i);
                        Commands.execute(commandFile);
                        break;
                    }
                    case 'y': {
                        wsdl2java.setInterfacePrefix(Strings.getString("y", args, ++i));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        if (wsdl2java.getMapPath() == null) {
            wsdl2java.setMapPath(".");
        }
        if (wsdl2java.getMapDir() == null) {
            wsdl2java.setMapDir(DEFAULT_INTERFACE_SUFFIX);
        }
        return wsdl2java;
    }

    public void wsdl2java() throws IOException, ClassNotFoundException, ParseException, WSDLException {
        Mappings.clear();
        if (this.url == null) {
            throw new IllegalArgumentException("missing URL");
        }
        Context context = new Context();
        byte[] bytes = ResourceLoaders.loadResource(this.url, context);
        Document doc = new Document(bytes);
        if (this.verbose) {
            System.out.println(doc);
        }
        String serviceName = this.getServiceName(doc);
        File file = new File(this.mapPath == null ? DEFAULT_INTERFACE_SUFFIX : this.mapPath, (serviceName = Strings.getLocalJavaName(serviceName)) + ".map");
        if (file.exists()) {
            file.delete();
            if (this.verbose) {
                System.out.println("deleted file " + file);
            }
        }
        this.interfacePrefix = this.interfacePrefix == null ? DEFAULT_INTERFACE_SUFFIX : this.interfacePrefix;
        String string = this.interfaceSuffix = this.interfaceSuffix == null ? DEFAULT_INTERFACE_SUFFIX : this.interfaceSuffix;
        if (this.mapPath != null) {
            Mappings.readMappings(this.mapPath);
        }
        if (this.pkg == null) {
            this.pkg = DEFAULT_INTERFACE_SUFFIX;
        }
        Mappings.setDefaultPackage(this.pkg);
        if (this.namespacePrefix != null) {
            Mappings.setNamespacePrefix(this.namespacePrefix);
        }
        WSDL wsdl = WSDLParser.newWSDL(this.url, doc, context);
        WSDLLoader.addToCache(this.url, wsdl);
        Binding[] soapBindings = wsdl.getBindings(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = WSDL2Java.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding);
        if (soapBindings.length == 0) {
            throw new IOException("no SOAP bindings found in the WSDL file");
        }
        boolean generateHelper = soapBindings.length == 1 && wsdl.getServices().hasMoreElements();
        int i = 0;
        while (i < soapBindings.length) {
            SOAPBinding binding = (SOAPBinding)soapBindings[i];
            String portTypeName = Strings.getLocalJavaName(binding.getPortType().getName());
            String javaName = Mappings.getJavaName(wsdl.getTargetNamespace(), portTypeName);
            if (javaName == null) {
                javaName = portTypeName;
            }
            String packageName = Strings.getJavaPackage(javaName);
            String interfaceName = Strings.getLocalJavaName(javaName);
            if (!interfaceName.startsWith(this.interfacePrefix)) {
                interfaceName = this.interfacePrefix + interfaceName;
            }
            if (!interfaceName.endsWith(this.interfaceSuffix)) {
                interfaceName = interfaceName + this.interfaceSuffix;
            }
            this.writeInterface(this.dir, binding, packageName, interfaceName, this.checkedExceptions, this.listener, this.generateFaults);
            if (generateHelper) {
                this.writeHelper(this.dir, packageName, serviceName, interfaceName, this.url, this.listener);
            }
            if (this.generateSkeleton) {
                String skeletonName = Strings.getLocalJavaName(javaName) + "Impl";
                this.writeSkeleton(this.dir, binding, packageName, skeletonName, this.checkedExceptions, this.listener, this.generateFaults);
            }
            ++i;
        }
        this.writeHolders(this.dir, soapBindings);
        this.writeDataAndMapFile(this.dir, this.mapDir, serviceName, wsdl, this.listener);
    }

    private void writeInterface(String dir, SOAPBinding binding, String packageName, String interfaceName, boolean checkedExceptions, IFileListener listener, boolean generateFaults) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeInterface(binding, packageName, interfaceName, printWriter, checkedExceptions, generateFaults);
        FileUtil.saveFile(dir, interfaceName, stringWriter.toString(), JAVA_EXTENSION, "interface");
        if (listener != null) {
            listener.written(interfaceName + JAVA_EXTENSION, dir);
        }
    }

    public void writeInterface(SOAPBinding binding, String packageName, String name, PrintWriter writer, boolean checkedExceptions, boolean generateFaults) throws SchemaException {
        writer.println("// " + WSDL2Java.getDescription());
        if (packageName != null) {
            writer.println("package " + packageName + ";\n");
        }
        if (checkedExceptions) {
            writer.println("import java.rmi.RemoteException;\n");
        }
        SOAPOperation[] operations = binding.getSOAPOperations();
        int i = 0;
        while (i < operations.length) {
            if (operations[i].isAsync()) {
                writer.println("import electric.util.async.Async;\n");
                break;
            }
            ++i;
        }
        writer.println("public interface " + name);
        writer.println("  {");
        int i2 = 0;
        while (i2 < operations.length) {
            writer.print("  " + this.getSignature(operations[i2], packageName, generateFaults));
            if (checkedExceptions && !generateFaults) {
                writer.print(" throws RemoteException");
            }
            writer.println(";");
            ++i2;
        }
        writer.println("  }");
    }

    private void writeSkeleton(String dir, SOAPBinding binding, String packageName, String skeletonName, boolean checkedExceptions, IFileListener listener, boolean generateFaults) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeSkeleton(binding, packageName, skeletonName, printWriter, checkedExceptions, generateFaults);
        FileUtil.saveFile(dir, skeletonName, stringWriter.toString(), JAVA_EXTENSION, "skeleton");
    }

    public void writeSkeleton(SOAPBinding binding, String packageName, String name, PrintWriter writer, boolean checkedExceptions, boolean generateFaults) throws SchemaException {
        writer.println("// " + WSDL2Java.getDescription());
        if (packageName != null) {
            writer.println("package " + packageName + ";\n");
        }
        if (checkedExceptions) {
            writer.println("import java.rmi.RemoteException;\n");
        }
        SOAPOperation[] operations = binding.getSOAPOperations();
        int i = 0;
        while (i < operations.length) {
            if (operations[i].isAsync()) {
                writer.println("import electric.util.async.Async;\n");
                break;
            }
            ++i;
        }
        writer.println("public class " + name);
        writer.println("  {");
        int i2 = 0;
        while (i2 < operations.length) {
            SOAPOperation operation = operations[i2];
            if (i2 > 0) {
                writer.println();
            }
            writer.print("  public " + this.getSignature(operation, packageName, generateFaults));
            writer.println();
            writer.println("    {");
            writer.println("    // default implementation");
            if (operations[i2].getReturnValue() != null) {
                String javaName = this.getJavaName(operation.getReturnValue(), packageName);
                if (javaName.equals("boolean")) {
                    writer.println("    return false;");
                } else if (javaName.equals("byte") || javaName.equals("short") || javaName.equals("int") || javaName.equals("long") || javaName.equals("float") || javaName.equals("double")) {
                    writer.println("    return 0;");
                } else if (javaName.equals("char")) {
                    writer.println("    return '0';");
                } else {
                    writer.println("    return null;");
                }
            }
            writer.println("    }");
            ++i2;
        }
        writer.println("  }");
    }

    private String getSignature(SOAPOperation operation, String packageName, boolean generateFaults) throws SchemaException {
        Parameter[] parameters = operation.parameters;
        StringBuffer buffer = new StringBuffer();
        if (operation.getReturnValue() != null) {
            buffer.append(this.getJavaName(operation.getReturnValue(), packageName)).append(' ');
        } else {
            buffer.append("void ");
        }
        buffer.append(operation.getOperation().getName());
        if (parameters.length == 0) {
            if (operation.isAsync()) {
                buffer.append("( Async result )");
            } else {
                buffer.append("()");
            }
        } else {
            buffer.append("( ");
            int i = 0;
            while (i < parameters.length) {
                buffer.append(this.getJavaName(parameters[i], packageName)).append(' ');
                buffer.append(parameters[i].getName());
                if (i < parameters.length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
            if (operation.isAsync()) {
                buffer.append(", Async result");
            }
            buffer.append(" )");
        }
        if (generateFaults || this.checkedExceptions) {
            this.generateExceptionDeclarations(operation, buffer);
        }
        return buffer.toString();
    }

    private void generateExceptionDeclarations(SOAPOperation operation, StringBuffer buffer) {
        SOAPMessageDecl[] faults = operation.getFaults();
        if (faults == null) {
            return;
        }
        boolean firstFault = true;
        if (this.checkedExceptions) {
            buffer.append(" throws RemoteException");
            firstFault = false;
        }
        if (!this.generateFaults) {
            return;
        }
        int i = 0;
        while (i < faults.length) {
            SOAPMessageDecl fault = faults[i];
            String exceptionType = this.prepareJavaException(operation.getBinding().getWSDL(), fault);
            if (exceptionType != null) {
                if (firstFault) {
                    buffer.append(" throws ");
                    firstFault = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(exceptionType);
            }
            ++i;
        }
    }

    private String prepareJavaException(WSDL wsdl, SOAPMessageDecl fault) {
        block14: {
            try {
                if (fault == null) {
                    if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"fault is null");
                    }
                    return null;
                }
                if (fault.messageDecl == null) {
                    if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"fault.messageDecl is null");
                    }
                    return null;
                }
                if (fault.messageDecl.getMessage() == null) {
                    if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"fault.messageDecl.getMessage() is null");
                    }
                    return null;
                }
                if (fault.messageDecl.getMessage().getPartCount() != 1) {
                    if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"faults messages must have one part");
                    }
                    return null;
                }
                Part faultPart = fault.messageDecl.getMessage().getPart(0);
                Type faultType = faultPart.getImplicitType();
                String messageName = faultPart.getMessage().getName();
                if (faultType instanceof ComplexType) {
                    if (this.mungeComplexException((ComplexType)faultType)) {
                        return faultType.getJavaName();
                    }
                    break block14;
                }
                if (faultType instanceof SimpleType || faultType instanceof ArrayType) {
                    ComplexType newType = this.mungeSimpleException(faultType, messageName, faultPart.getName());
                    faultPart.setType(newType);
                    faultType = newType;
                    wsdl.add(faultType);
                    return faultType.getJavaName();
                }
                ComplexType newType = this.mungeSimpleException(faultType, messageName, faultPart.getName());
                faultPart.setType(newType);
                faultType = newType;
                wsdl.add(faultType);
                return faultType.getJavaName();
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block14;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "ignored exception while processing fault declaration", exception);
            }
        }
        if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"could not process fault with complexType");
        }
        return null;
    }

    private ComplexType mungeSimpleException(Type faultType, String messageName, String partName) throws SchemaException {
        Schema schema = faultType.getSchema();
        ComplexType newType = new ComplexType(schema);
        newType.setName(messageName);
        newType.setAnonymous(false);
        ComplexContent complexContent = new ComplexContent(newType);
        complexContent.setBaseType(class$java$lang$Exception == null ? (class$java$lang$Exception = WSDL2Java.class$("java.lang.Exception")) : class$java$lang$Exception);
        Sequence sequence = new Sequence(newType);
        SchemaElement faultValue = new SchemaElement(partName, faultType, schema.getQualifyElements());
        faultValue.setAccessor(new FieldAccessor(faultValue, partName));
        sequence.addElement(faultValue);
        complexContent.setModel(sequence);
        newType.setModel(complexContent);
        newType.setJavaName(Mappings.getJavaName(newType.getNamespace(), newType.getName()));
        return newType;
    }

    private boolean mungeComplexException(ComplexType faultType) throws SchemaException, ClassNotFoundException {
        IModel model = faultType.getModel();
        if (model == null) {
            ComplexContent complexContent = new ComplexContent(faultType);
            complexContent.setBaseType(class$java$lang$Exception == null ? (class$java$lang$Exception = WSDL2Java.class$("java.lang.Exception")) : class$java$lang$Exception);
            Sequence sequence = new Sequence(faultType);
            complexContent.setModel(sequence);
            faultType.replaceModel(complexContent);
            return true;
        }
        if (model instanceof ComplexContent) {
            ComplexContent complexContent = (ComplexContent)model;
            Type baseType = complexContent.getBaseType();
            Class baseClass = baseType.getJavaClass();
            if (baseClass != null && (class$java$lang$Exception == null ? (class$java$lang$Exception = WSDL2Java.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(baseClass)) {
                return true;
            }
            try {
                this.mungeComplexException((ComplexType)baseType);
                return true;
            }
            catch (Throwable exception) {
                if (this.forceExceptionInheritance) {
                    complexContent.setBaseType(class$java$lang$Exception == null ? (class$java$lang$Exception = WSDL2Java.class$("java.lang.Exception")) : class$java$lang$Exception);
                    return true;
                }
                return false;
            }
        }
        if (model instanceof SimpleContent) {
            if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)("fault with complexType/simpleContent not handled:" + faultType.getName()));
            }
            return false;
        }
        if (model instanceof All) {
            All sequence = (All)model;
            ComplexContent complexContent = new ComplexContent(faultType);
            complexContent.setBaseType(class$java$lang$Exception == null ? (class$java$lang$Exception = WSDL2Java.class$("java.lang.Exception")) : class$java$lang$Exception);
            complexContent.setModel(sequence);
            faultType.replaceModel(complexContent);
            return true;
        }
        if (model instanceof Group) {
            if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)("fault with complexContent/group not handled:" + faultType.getName()));
            }
            return false;
        }
        if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)("fault type handled:" + faultType.getName()));
        }
        return false;
    }

    private String getJavaName(Parameter parameter, String packageName) throws SchemaException {
        String javaName = parameter.getJavaName();
        if (ArrayUtil.equals(Strings.getJavaPackage(javaName), packageName) || javaName.startsWith("java.lang")) {
            javaName = Strings.getLocalJavaName(javaName);
        }
        return javaName;
    }

    private void writeHolders(String dir, Binding[] bindings) throws SchemaException, IOException {
        Vector holders = this.getHolders(bindings);
        Enumeration enumeration = holders.elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            this.writeHolder(dir, type.getJavaName());
        }
    }

    private Vector getHolders(Binding[] bindings) throws SchemaException {
        Vector<Type> holders = new Vector<Type>();
        int i = 0;
        while (i < bindings.length) {
            SOAPBinding binding = (SOAPBinding)bindings[i];
            SOAPOperation[] operations = binding.getSOAPOperations();
            int j = 0;
            while (j < operations.length) {
                SOAPOperation operation = operations[j];
                int k = 0;
                while (k < operation.parameters.length) {
                    Parameter parameter = operation.parameters[k];
                    if (parameter instanceof Out && !holders.contains(parameter.getType())) {
                        holders.addElement(parameter.getType());
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return holders;
    }

    private void writeHolder(String dir, String className) throws IOException {
        String outHolderClassName = Holders.getOutHolderClassName(className);
        try {
            ClassLoaders.loadClass(outHolderClassName);
            Log.log(outHolderClassName + " already exists");
        }
        catch (ClassNotFoundException exception) {
            String fileName = Strings.getLocalJavaName(outHolderClassName);
            String javaCode = Holders.getOutHolderJava(className);
            FileUtil.saveFile(dir, fileName, javaCode, JAVA_EXTENSION, "out holder");
        }
        String inOutHolderClassName = Holders.getInOutHolderClassName(className);
        try {
            ClassLoaders.loadClass(inOutHolderClassName);
            Log.log(inOutHolderClassName + " already exists");
        }
        catch (ClassNotFoundException exception) {
            String fileName = Strings.getLocalJavaName(inOutHolderClassName);
            String javaCode = Holders.getInOutHolderJava(className);
            FileUtil.saveFile(dir, fileName, javaCode, JAVA_EXTENSION, "inout holder");
        }
    }

    private void writeHelper(String dir, String packageName, String name, String interfaceName, String url, IFileListener listener) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.writeHelper(packageName, name, interfaceName, url, printWriter);
        FileUtil.saveFile(dir, name + "Helper", stringWriter.toString(), JAVA_EXTENSION, "helper");
        if (listener != null) {
            listener.written(name + "Helper" + JAVA_EXTENSION, dir);
        }
    }

    public void writeHelper(String packageName, String name, String interfaceName, String url, PrintWriter writer) {
        String urlPath = url;
        try {
            XURL xurl = new XURL(url);
            if (xurl.getProtocol() == null) {
                urlPath = "file:/" + Strings.replace(new File(url).getAbsolutePath(), "\\", "/");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        writer.println("// " + WSDL2Java.getDescription());
        if (packageName != null) {
            writer.println("package " + packageName + ";\n");
        }
        writer.println("import electric.registry.Registry;");
        writer.println("import electric.registry.RegistryException;");
        writer.println();
        writer.println("public class " + name + "Helper");
        writer.println("  {");
        writer.println("  public static " + interfaceName + " bind() throws RegistryException");
        writer.println("    {");
        writer.println("    return bind( \"" + urlPath + "\" );");
        writer.println("    }");
        writer.println();
        writer.println("  public static " + interfaceName + " bind( String url ) throws RegistryException");
        writer.println("    {");
        writer.println("    return (" + interfaceName + ") Registry.bind( url, " + interfaceName + ".class );");
        writer.println("    }");
        writer.println("  }");
    }

    private void writeDataAndMapFile(String dir, String mapDir, String name, WSDL wsdl, IFileListener listener) throws SchemaException, IOException {
        Enumeration types = wsdl.getTypesForBindings(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = WSDL2Java.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding);
        if (!types.hasMoreElements()) {
            return;
        }
        Document mappings = new Document();
        mappings.addComment(WSDL2Java.getDescription());
        Element root = mappings.newRoot();
        root.setNamespace("map", SchemaProperties.getTmeMap());
        root.setName("map", "mappings");
        while (types.hasMoreElements()) {
            Type type = (Type)types.nextElement();
            if (Mappings.getMapping(type.getNamespace(), type.getName()) != null || type.isStandard() || type.isAnonymous() && type.isInhibit()) continue;
            if (type instanceof ArrayType) {
                type.appendSchema(root, true);
                continue;
            }
            if (!type.isInhibit()) {
                this.writeDataStructure(dir, type, listener);
            }
            type.appendSchema(root, true);
        }
        if (root.hasChildren()) {
            this.writeMapFile(mapDir, name, mappings);
        }
    }

    private void writeDataStructure(String dir, Type type, IFileListener listener) throws IOException {
        JavaSource source = new JavaSource();
        source.setGenerateAccessors(this.generateAccessors);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("// " + WSDL2Java.getDescription());
        type.writeJava(source);
        source.write(printWriter);
        String filename = Strings.getLocalJavaName(type.getJavaName());
        FileUtil.saveFile(dir, filename, stringWriter.toString(), JAVA_EXTENSION, "structure");
        if (listener != null) {
            listener.written(filename + JAVA_EXTENSION, dir);
        }
    }

    private void writeMapFile(String mapPath, String name, Document mappings) throws IOException {
        mapPath = mapPath == null ? DEFAULT_INTERFACE_SUFFIX : mapPath;
        String content = mappings.toString();
        if (mapPath.endsWith(".jar")) {
            Jar.saveFile(mapPath, name + ".map", content);
        } else {
            if (mapPath.length() > 0 && !mapPath.endsWith(ILoaderConstants.FILE_SEPARATOR)) {
                mapPath = mapPath + ILoaderConstants.FILE_SEPARATOR;
            }
            FileUtil.saveFile(mapPath, name, content, ".map", "map");
        }
    }

    public String getServiceName(Document wsdl) {
        String name = null;
        Elements elements = wsdl.getRoot().getElements("service");
        name = elements.hasMoreElements() ? elements.next().getAttribute("name") : wsdl.getRoot().getElement("binding").getAttribute("name");
        name = Strings.getLocalJavaName(name);
        String namespace = wsdl.getRoot().getAttribute("targetNamespace");
        if (namespace != null && Mappings.getPackage(namespace) != null) {
            return Mappings.getJavaName(namespace, name);
        }
        return name;
    }

    public String getServiceName(WSDL wsdl) {
        String name = null;
        Enumeration enumeration = wsdl.getServices();
        name = enumeration.hasMoreElements() ? ((Service)enumeration.nextElement()).getName() : wsdl.getBindings(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = WSDL2Java.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding)[0].getName();
        name = Strings.getLocalJavaName(name);
        if (Mappings.getPackage(wsdl.getTargetNamespace()) != null) {
            return Mappings.getJavaName(wsdl.getTargetNamespace(), name);
        }
        return name;
    }

    private static String getDescription() {
        return "generated by " + Product.getShortDescription() + " (wsdl2java) on " + new Date();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getPkg() {
        return this.pkg;
    }

    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    public String getMapPath() {
        return this.mapPath;
    }

    public void setMapPath(String mapPath) {
        this.mapPath = mapPath;
    }

    public String getMapDir() {
        return this.mapDir;
    }

    public void setMapDir(String mapDir) {
        this.mapDir = mapDir;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public void setGenerateSkeleton(boolean generateSkeleton) {
        this.generateSkeleton = generateSkeleton;
    }

    public boolean isCheckedExceptions() {
        return this.checkedExceptions;
    }

    public void setCheckedExceptions(boolean checkedExceptions) {
        this.checkedExceptions = checkedExceptions;
    }

    public boolean isGenerateAccessors() {
        return this.generateAccessors;
    }

    public void setGenerateAccessors(boolean generateAccessors) {
        this.generateAccessors = generateAccessors;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getInterfacePrefix() {
        return this.interfacePrefix;
    }

    public void setInterfacePrefix(String interfacePrefix) {
        this.interfacePrefix = interfacePrefix;
    }

    public boolean isGenerateFaults() {
        return this.generateFaults;
    }

    public void setGenerateFaults(boolean generateFaults) {
        this.generateFaults = generateFaults;
    }

    public boolean isForceExceptionInheritance() {
        return this.forceExceptionInheritance;
    }

    public void setForceExceptionInheritance(boolean forceExceptionInheritance) {
        this.forceExceptionInheritance = forceExceptionInheritance;
    }

    public String getInterfaceSuffix() {
        return this.interfaceSuffix;
    }

    public void setInterfaceSuffix(String interfaceSuffix) {
        this.interfaceSuffix = interfaceSuffix;
    }

    public IFileListener getListener() {
        return this.listener;
    }

    public void setListener(IFileListener listener) {
        this.listener = listener;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

