/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb;

import electric.util.UUID;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.util.time.TimeUtil;
import electric.xdb.IActiveData;
import electric.xdb.IXDBConstants;
import electric.xdb.Id;
import electric.xml.Element;
import electric.xml.io.literal.LiteralReader;
import electric.xml.io.literal.LiteralWriter;

public final class Data
implements IXDBConstants,
ILoggingConstants {
    private Element data;
    private transient Id id;
    private transient boolean removed;
    private transient long dieAt;
    private transient boolean nosync;
    private transient byte active;
    private transient boolean parsedHeader;
    private transient boolean parsedBody;
    private transient Object object;
    private transient boolean activated;

    public Data() {
        this.active = 0;
    }

    public Data(Element envelope) {
        this.active = 0;
        this.data = envelope;
        Element idElement = Data.getId(envelope);
        if (idElement != null && !idElement.hasElement("timestamp")) {
            idElement.setLong("timestamp", TimeUtil.now());
        }
    }

    public Data(Object object) {
        this(new UUID().getKey(), object);
    }

    public Data(String key, Object object) {
        this(new Id(key), object);
    }

    public Data(String key, Object object, long dieAt) {
        this(new Id(key), object, false, dieAt, true);
    }

    public Data(Id id, Object object) {
        this(id, object, false, 0L, true);
    }

    public Data(Id id, Object object, boolean removed, long dieAt, boolean sync) {
        block3: {
            this.active = 0;
            this.id = id;
            this.removed = removed;
            this.dieAt = dieAt;
            this.nosync = !sync;
            this.object = object;
            this.active = object instanceof IActiveData ? (byte)(((IActiveData)object).isMany() ? 2 : 1) : (byte)0;
            this.parsedHeader = true;
            this.parsedBody = true;
            try {
                this.data = Data.newEnvelope();
                this.setHeader();
                Element body = this.data.addElement("soap", "Body");
                if (object != null) {
                    String type = Strings.getLocalJavaName(object.getClass().getName());
                    Element element = new Element(type);
                    LiteralWriter writer = new LiteralWriter(element);
                    writer.writeObject(object);
                    body.addElement(element);
                }
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block3;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception constructing Data for " + object, exception);
            }
        }
    }

    public Data(Id id, Element element, boolean removed, long dieAt, boolean sync, byte active) {
        this.active = 0;
        this.id = id;
        this.removed = removed;
        this.dieAt = dieAt;
        this.nosync = !sync;
        this.active = active;
        this.parsedHeader = true;
        this.parsedBody = false;
        this.data = Data.newEnvelope();
        this.setHeader();
        Element body = this.data.addElement("soap", "Body");
        body.addElement(element);
    }

    public String toString() {
        return "Data( " + this.data + " )";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Data)) {
            return false;
        }
        return this.id.equals(((Data)object).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Element getEnvelope() {
        return this.data;
    }

    public Element getEnvelopeCopy() {
        Element copy = new Element(this.data);
        Element idElement = Data.getId(copy);
        if (idElement != null) {
            idElement.removeElement("timestamp");
        }
        return copy;
    }

    public Element getHeader() {
        return this.data == null ? null : this.data.getElement("http://schemas.xmlsoap.org/soap/envelope/", "Header");
    }

    public synchronized Id getId() {
        if (!this.parsedHeader) {
            this.parseHeader();
        }
        return this.id;
    }

    public String getKey() {
        return this.getId().getKey();
    }

    public long getTimestamp() {
        return this.getId().getTimestamp();
    }

    public synchronized boolean isRemoved() {
        if (!this.parsedHeader) {
            this.parseHeader();
        }
        return this.removed;
    }

    public synchronized long getDieAt() {
        if (!this.parsedHeader) {
            this.parseHeader();
        }
        return this.dieAt;
    }

    public synchronized boolean isSync() {
        if (!this.parsedHeader) {
            this.parseHeader();
        }
        return !this.nosync;
    }

    public synchronized byte getActive() {
        if (!this.parsedHeader) {
            this.parseHeader();
        }
        return this.active;
    }

    private void parseHeader() {
        Element dieAfterElement;
        this.parsedHeader = true;
        Element header = this.getHeader();
        if (header == null) {
            return;
        }
        this.removed = header.hasElement("removed");
        Element dieAtElement = header.getElement("dieAt");
        if (dieAtElement != null) {
            this.dieAt = dieAtElement.getLong();
        }
        if ((dieAfterElement = header.getElement("dieAfter")) != null) {
            this.dieAt = TimeUtil.now() + dieAfterElement.getLong();
        }
        this.nosync = header.hasElement("nosync");
        this.active = header.hasElement("oneActive") ? (byte)1 : (header.hasElement("manyActive") ? (byte)2 : (byte)0);
        Element idElement = header.getElement("id");
        if (idElement != null) {
            String key = idElement.getString("key");
            long timestamp = 0L;
            if (idElement.hasElement("timestamp")) {
                timestamp = idElement.getLong("timestamp");
            }
            this.id = new Id(key, timestamp);
        }
    }

    private void setHeader() {
        Element header = this.data.addElement("soap", "Header");
        if (this.id != null) {
            Element keyElement = header.addElement("id");
            if (this.id.getKey() != null) {
                keyElement.setString("key", this.id.getKey());
            }
            if (this.id.getTimestamp() != 0L) {
                keyElement.setLong("timestamp", this.id.getTimestamp());
            }
        }
        if (this.removed) {
            header.addElement("removed");
        }
        if (this.dieAt > 0L) {
            header.setLong("dieAt", this.dieAt);
        }
        if (this.nosync) {
            header.setBoolean("nosync", true);
        }
        if (this.active == 1) {
            header.addElement("oneActive");
        } else if (this.active == 2) {
            header.addElement("manyActive");
        }
    }

    private static Element getId(Element data) {
        Element header = data.getElement("Header");
        return header == null ? null : header.getElement("id");
    }

    public Element getBody() {
        return this.data == null ? null : this.data.getElement("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    }

    public synchronized void flushObject() {
        this.parsedBody = false;
        this.object = null;
    }

    public synchronized Object getObject() {
        if (!this.parsedBody) {
            this.parseBody();
        }
        return this.object;
    }

    private void parseBody() {
        block2: {
            this.parsedBody = true;
            Element body = this.getBody();
            try {
                Element root = body.getFirstElement();
                LiteralReader reader = new LiteralReader(root);
                this.object = reader.readObject();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception parsing Data " + body, exception);
            }
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean flag) {
        this.activated = flag;
    }

    public static Element newEnvelope() {
        Element envelope = new Element();
        envelope.setNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        envelope.setName("soap", "Envelope");
        return envelope;
    }

    public static Data getRemoveDataWithKeyData(String key) {
        Element envelope = Data.newEnvelope();
        Element header = envelope.addElement("soap", "Header");
        Element idElement = header.addElement("id");
        idElement.setString("key", key);
        idElement.setLong("timestamp", TimeUtil.now());
        header.addElement("removed");
        return new Data(envelope);
    }
}

