/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.server;

import electric.util.Context;
import electric.util.thread.Lock;
import electric.xdb.Data;
import electric.xdb.XDBException;
import electric.xdb.server.IXDBLoader;
import electric.xdb.server.IXDBServer;
import electric.xdb.server.LocalXDBServers;
import electric.xdb.server.XDBCreator;
import electric.xdb.server.XDBServer;

public class LocalXDBServerFactory {
    private static IXDBLoader loader = new XDBCreator();

    public static void setLoader(IXDBLoader loader) {
        LocalXDBServerFactory.loader = loader;
    }

    public static IXDBServer getServer(String groupName) throws XDBException {
        return LocalXDBServerFactory.getServer(groupName, XDBServer.getDefaultReplicationFactor());
    }

    public static IXDBServer getServer(String groupName, int replicationFactor) throws XDBException {
        return LocalXDBServerFactory.getServer(groupName, replicationFactor, new String[0]);
    }

    public static IXDBServer getServer(String groupName, int replicationFactor, String[] urls) throws XDBException {
        return LocalXDBServerFactory.getServer(groupName, replicationFactor, urls, new Context(), new Data[0]);
    }

    public static IXDBServer getServer(String groupName, int replicationFactor, String[] urls, Context context, Data[] data) throws XDBException {
        return LocalXDBServerFactory.getServer(groupName, replicationFactor, urls, context, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IXDBServer getServer(String groupName, int replicationFactor, String[] urls, Context context, Data[] data, boolean xxx) throws XDBException {
        Lock lock;
        block3: {
            lock = Lock.obtain("XDBServer-" + groupName);
            try {
                IXDBServer server = LocalXDBServers.getServer(groupName);
                if (server == null) break block3;
                IXDBServer iXDBServer = server;
                Object var10_10 = null;
                lock.release();
                return iXDBServer;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                lock.release();
                throw throwable;
            }
        }
        IXDBServer iXDBServer = loader.loadServer(groupName, replicationFactor, urls, context, data, xxx);
        Object var10_11 = null;
        lock.release();
        return iXDBServer;
    }
}

